/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core;

import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.LongSet;
import com.carrotsearch.hppc.ObjectIntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.core.GraphDimensions;

@Generated(from="GraphDimensions", generator="Immutables")
public final class ImmutableGraphDimensions
implements GraphDimensions {
    private final long nodeCount;
    private final long highestPossibleNodeCount;
    private final long relCountUpperBound;
    private final Map<RelationshipType, Long> relationshipCounts;
    private final long highestRelationshipId;
    @Nullable
    private final LongSet nodeLabelTokens;
    @Nullable
    private final LongSet relationshipTypeTokens;
    @Nullable
    private final IntObjectMap<List<NodeLabel>> tokenNodeLabelMapping;
    @Nullable
    private final IntObjectMap<List<RelationshipType>> tokenRelationshipTypeMapping;
    private final transient long averageDegree;
    @Nullable
    private final transient ObjectIntMap<RelationshipType> relationshipTypeTokenMapping;
    private final Map<String, Integer> nodePropertyTokens;
    private final Map<String, Integer> relationshipPropertyTokens;
    private final int estimationNodeLabelCount;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGraphDimensions(long nodeCount, long highestPossibleNodeCount, long relCountUpperBound, Map<? extends RelationshipType, ? extends Long> relationshipCounts, long highestRelationshipId, @Nullable LongSet nodeLabelTokens, @Nullable LongSet relationshipTypeTokens, @Nullable IntObjectMap<List<NodeLabel>> tokenNodeLabelMapping, @Nullable IntObjectMap<List<RelationshipType>> tokenRelationshipTypeMapping, Map<String, ? extends Integer> nodePropertyTokens, Map<String, ? extends Integer> relationshipPropertyTokens, int estimationNodeLabelCount) {
        this.nodeCount = nodeCount;
        this.initShim.highestPossibleNodeCount(highestPossibleNodeCount);
        this.initShim.relCountUpperBound(relCountUpperBound);
        this.initShim.relationshipCounts(ImmutableGraphDimensions.createUnmodifiableMap(true, false, relationshipCounts));
        this.initShim.highestRelationshipId(highestRelationshipId);
        this.nodeLabelTokens = nodeLabelTokens;
        this.relationshipTypeTokens = relationshipTypeTokens;
        this.tokenNodeLabelMapping = tokenNodeLabelMapping;
        this.tokenRelationshipTypeMapping = tokenRelationshipTypeMapping;
        this.initShim.nodePropertyTokens(ImmutableGraphDimensions.createUnmodifiableMap(true, false, nodePropertyTokens));
        this.initShim.relationshipPropertyTokens(ImmutableGraphDimensions.createUnmodifiableMap(true, false, relationshipPropertyTokens));
        this.initShim.estimationNodeLabelCount(estimationNodeLabelCount);
        this.highestPossibleNodeCount = this.initShim.highestPossibleNodeCount();
        this.relCountUpperBound = this.initShim.relCountUpperBound();
        this.relationshipCounts = this.initShim.relationshipCounts();
        this.highestRelationshipId = this.initShim.highestRelationshipId();
        this.averageDegree = this.initShim.averageDegree();
        this.relationshipTypeTokenMapping = this.initShim.relationshipTypeTokenMapping();
        this.nodePropertyTokens = this.initShim.nodePropertyTokens();
        this.relationshipPropertyTokens = this.initShim.relationshipPropertyTokens();
        this.estimationNodeLabelCount = this.initShim.estimationNodeLabelCount();
        this.initShim = null;
    }

    private ImmutableGraphDimensions(Builder builder) {
        this.nodeCount = builder.nodeCount;
        this.nodeLabelTokens = builder.nodeLabelTokens;
        this.relationshipTypeTokens = builder.relationshipTypeTokens;
        this.tokenNodeLabelMapping = builder.tokenNodeLabelMapping;
        this.tokenRelationshipTypeMapping = builder.tokenRelationshipTypeMapping;
        if (builder.highestPossibleNodeCountIsSet()) {
            this.initShim.highestPossibleNodeCount(builder.highestPossibleNodeCount);
        }
        if (builder.relCountUpperBoundIsSet()) {
            this.initShim.relCountUpperBound(builder.relCountUpperBound);
        }
        if (builder.relationshipCountsIsSet()) {
            this.initShim.relationshipCounts(builder.relationshipCounts == null ? Collections.emptyMap() : ImmutableGraphDimensions.createUnmodifiableMap(false, false, builder.relationshipCounts));
        }
        if (builder.highestRelationshipIdIsSet()) {
            this.initShim.highestRelationshipId(builder.highestRelationshipId);
        }
        if (builder.nodePropertyTokensIsSet()) {
            this.initShim.nodePropertyTokens(builder.nodePropertyTokens == null ? Collections.emptyMap() : ImmutableGraphDimensions.createUnmodifiableMap(false, false, builder.nodePropertyTokens));
        }
        if (builder.relationshipPropertyTokensIsSet()) {
            this.initShim.relationshipPropertyTokens(builder.relationshipPropertyTokens == null ? Collections.emptyMap() : ImmutableGraphDimensions.createUnmodifiableMap(false, false, builder.relationshipPropertyTokens));
        }
        if (builder.estimationNodeLabelCountIsSet()) {
            this.initShim.estimationNodeLabelCount(builder.estimationNodeLabelCount);
        }
        this.highestPossibleNodeCount = this.initShim.highestPossibleNodeCount();
        this.relCountUpperBound = this.initShim.relCountUpperBound();
        this.relationshipCounts = this.initShim.relationshipCounts();
        this.highestRelationshipId = this.initShim.highestRelationshipId();
        this.averageDegree = this.initShim.averageDegree();
        this.relationshipTypeTokenMapping = this.initShim.relationshipTypeTokenMapping();
        this.nodePropertyTokens = this.initShim.nodePropertyTokens();
        this.relationshipPropertyTokens = this.initShim.relationshipPropertyTokens();
        this.estimationNodeLabelCount = this.initShim.estimationNodeLabelCount();
        this.initShim = null;
    }

    private ImmutableGraphDimensions(ImmutableGraphDimensions original, long nodeCount, long highestPossibleNodeCount, long relCountUpperBound, Map<RelationshipType, Long> relationshipCounts, long highestRelationshipId, @Nullable LongSet nodeLabelTokens, @Nullable LongSet relationshipTypeTokens, @Nullable IntObjectMap<List<NodeLabel>> tokenNodeLabelMapping, @Nullable IntObjectMap<List<RelationshipType>> tokenRelationshipTypeMapping, Map<String, Integer> nodePropertyTokens, Map<String, Integer> relationshipPropertyTokens, int estimationNodeLabelCount) {
        this.nodeCount = nodeCount;
        this.initShim.highestPossibleNodeCount(highestPossibleNodeCount);
        this.initShim.relCountUpperBound(relCountUpperBound);
        this.initShim.relationshipCounts(relationshipCounts);
        this.initShim.highestRelationshipId(highestRelationshipId);
        this.nodeLabelTokens = nodeLabelTokens;
        this.relationshipTypeTokens = relationshipTypeTokens;
        this.tokenNodeLabelMapping = tokenNodeLabelMapping;
        this.tokenRelationshipTypeMapping = tokenRelationshipTypeMapping;
        this.initShim.nodePropertyTokens(nodePropertyTokens);
        this.initShim.relationshipPropertyTokens(relationshipPropertyTokens);
        this.initShim.estimationNodeLabelCount(estimationNodeLabelCount);
        this.highestPossibleNodeCount = this.initShim.highestPossibleNodeCount();
        this.relCountUpperBound = this.initShim.relCountUpperBound();
        this.relationshipCounts = this.initShim.relationshipCounts();
        this.highestRelationshipId = this.initShim.highestRelationshipId();
        this.averageDegree = this.initShim.averageDegree();
        this.relationshipTypeTokenMapping = this.initShim.relationshipTypeTokenMapping();
        this.nodePropertyTokens = this.initShim.nodePropertyTokens();
        this.relationshipPropertyTokens = this.initShim.relationshipPropertyTokens();
        this.estimationNodeLabelCount = this.initShim.estimationNodeLabelCount();
        this.initShim = null;
    }

    private long highestPossibleNodeCountInitialize() {
        return GraphDimensions.super.highestPossibleNodeCount();
    }

    private long relCountUpperBoundInitialize() {
        return GraphDimensions.super.relCountUpperBound();
    }

    private Map<RelationshipType, Long> relationshipCountsInitialize() {
        return GraphDimensions.super.relationshipCounts();
    }

    private long highestRelationshipIdInitialize() {
        return GraphDimensions.super.highestRelationshipId();
    }

    private long averageDegreeInitialize() {
        return GraphDimensions.super.averageDegree();
    }

    @Nullable
    private ObjectIntMap<RelationshipType> relationshipTypeTokenMappingInitialize() {
        return GraphDimensions.super.relationshipTypeTokenMapping();
    }

    private Map<String, Integer> nodePropertyTokensInitialize() {
        return GraphDimensions.super.nodePropertyTokens();
    }

    private Map<String, Integer> relationshipPropertyTokensInitialize() {
        return GraphDimensions.super.relationshipPropertyTokens();
    }

    private int estimationNodeLabelCountInitialize() {
        return GraphDimensions.super.estimationNodeLabelCount();
    }

    @Override
    public long nodeCount() {
        return this.nodeCount;
    }

    @Override
    public long highestPossibleNodeCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.highestPossibleNodeCount() : this.highestPossibleNodeCount;
    }

    @Override
    public long relCountUpperBound() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relCountUpperBound() : this.relCountUpperBound;
    }

    @Override
    public Map<RelationshipType, Long> relationshipCounts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipCounts() : this.relationshipCounts;
    }

    @Override
    public long highestRelationshipId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.highestRelationshipId() : this.highestRelationshipId;
    }

    @Override
    @Nullable
    public LongSet nodeLabelTokens() {
        return this.nodeLabelTokens;
    }

    @Override
    @Nullable
    public LongSet relationshipTypeTokens() {
        return this.relationshipTypeTokens;
    }

    @Override
    @Nullable
    public IntObjectMap<List<NodeLabel>> tokenNodeLabelMapping() {
        return this.tokenNodeLabelMapping;
    }

    @Override
    @Nullable
    public IntObjectMap<List<RelationshipType>> tokenRelationshipTypeMapping() {
        return this.tokenRelationshipTypeMapping;
    }

    @Override
    public long averageDegree() {
        InitShim shim = this.initShim;
        return shim != null ? shim.averageDegree() : this.averageDegree;
    }

    @Override
    @Nullable
    public ObjectIntMap<RelationshipType> relationshipTypeTokenMapping() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypeTokenMapping() : this.relationshipTypeTokenMapping;
    }

    @Override
    public Map<String, Integer> nodePropertyTokens() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodePropertyTokens() : this.nodePropertyTokens;
    }

    @Override
    public Map<String, Integer> relationshipPropertyTokens() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipPropertyTokens() : this.relationshipPropertyTokens;
    }

    @Override
    public int estimationNodeLabelCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.estimationNodeLabelCount() : this.estimationNodeLabelCount;
    }

    public final ImmutableGraphDimensions withNodeCount(long value) {
        if (this.nodeCount == value) {
            return this;
        }
        return new ImmutableGraphDimensions(this, value, this.highestPossibleNodeCount, this.relCountUpperBound, this.relationshipCounts, this.highestRelationshipId, this.nodeLabelTokens, this.relationshipTypeTokens, this.tokenNodeLabelMapping, this.tokenRelationshipTypeMapping, this.nodePropertyTokens, this.relationshipPropertyTokens, this.estimationNodeLabelCount);
    }

    public final ImmutableGraphDimensions withHighestPossibleNodeCount(long value) {
        if (this.highestPossibleNodeCount == value) {
            return this;
        }
        return new ImmutableGraphDimensions(this, this.nodeCount, value, this.relCountUpperBound, this.relationshipCounts, this.highestRelationshipId, this.nodeLabelTokens, this.relationshipTypeTokens, this.tokenNodeLabelMapping, this.tokenRelationshipTypeMapping, this.nodePropertyTokens, this.relationshipPropertyTokens, this.estimationNodeLabelCount);
    }

    public final ImmutableGraphDimensions withRelCountUpperBound(long value) {
        if (this.relCountUpperBound == value) {
            return this;
        }
        return new ImmutableGraphDimensions(this, this.nodeCount, this.highestPossibleNodeCount, value, this.relationshipCounts, this.highestRelationshipId, this.nodeLabelTokens, this.relationshipTypeTokens, this.tokenNodeLabelMapping, this.tokenRelationshipTypeMapping, this.nodePropertyTokens, this.relationshipPropertyTokens, this.estimationNodeLabelCount);
    }

    public final ImmutableGraphDimensions withRelationshipCounts(Map<? extends RelationshipType, ? extends Long> entries) {
        if (this.relationshipCounts == entries) {
            return this;
        }
        Map<RelationshipType, Long> newValue = ImmutableGraphDimensions.createUnmodifiableMap(true, false, entries);
        return new ImmutableGraphDimensions(this, this.nodeCount, this.highestPossibleNodeCount, this.relCountUpperBound, newValue, this.highestRelationshipId, this.nodeLabelTokens, this.relationshipTypeTokens, this.tokenNodeLabelMapping, this.tokenRelationshipTypeMapping, this.nodePropertyTokens, this.relationshipPropertyTokens, this.estimationNodeLabelCount);
    }

    public final ImmutableGraphDimensions withHighestRelationshipId(long value) {
        if (this.highestRelationshipId == value) {
            return this;
        }
        return new ImmutableGraphDimensions(this, this.nodeCount, this.highestPossibleNodeCount, this.relCountUpperBound, this.relationshipCounts, value, this.nodeLabelTokens, this.relationshipTypeTokens, this.tokenNodeLabelMapping, this.tokenRelationshipTypeMapping, this.nodePropertyTokens, this.relationshipPropertyTokens, this.estimationNodeLabelCount);
    }

    public final ImmutableGraphDimensions withNodeLabelTokens(@Nullable LongSet value) {
        if (this.nodeLabelTokens == value) {
            return this;
        }
        return new ImmutableGraphDimensions(this, this.nodeCount, this.highestPossibleNodeCount, this.relCountUpperBound, this.relationshipCounts, this.highestRelationshipId, value, this.relationshipTypeTokens, this.tokenNodeLabelMapping, this.tokenRelationshipTypeMapping, this.nodePropertyTokens, this.relationshipPropertyTokens, this.estimationNodeLabelCount);
    }

    public final ImmutableGraphDimensions withRelationshipTypeTokens(@Nullable LongSet value) {
        if (this.relationshipTypeTokens == value) {
            return this;
        }
        return new ImmutableGraphDimensions(this, this.nodeCount, this.highestPossibleNodeCount, this.relCountUpperBound, this.relationshipCounts, this.highestRelationshipId, this.nodeLabelTokens, value, this.tokenNodeLabelMapping, this.tokenRelationshipTypeMapping, this.nodePropertyTokens, this.relationshipPropertyTokens, this.estimationNodeLabelCount);
    }

    public final ImmutableGraphDimensions withTokenNodeLabelMapping(@Nullable IntObjectMap<List<NodeLabel>> value) {
        if (this.tokenNodeLabelMapping == value) {
            return this;
        }
        return new ImmutableGraphDimensions(this, this.nodeCount, this.highestPossibleNodeCount, this.relCountUpperBound, this.relationshipCounts, this.highestRelationshipId, this.nodeLabelTokens, this.relationshipTypeTokens, value, this.tokenRelationshipTypeMapping, this.nodePropertyTokens, this.relationshipPropertyTokens, this.estimationNodeLabelCount);
    }

    public final ImmutableGraphDimensions withTokenRelationshipTypeMapping(@Nullable IntObjectMap<List<RelationshipType>> value) {
        if (this.tokenRelationshipTypeMapping == value) {
            return this;
        }
        return new ImmutableGraphDimensions(this, this.nodeCount, this.highestPossibleNodeCount, this.relCountUpperBound, this.relationshipCounts, this.highestRelationshipId, this.nodeLabelTokens, this.relationshipTypeTokens, this.tokenNodeLabelMapping, value, this.nodePropertyTokens, this.relationshipPropertyTokens, this.estimationNodeLabelCount);
    }

    public final ImmutableGraphDimensions withNodePropertyTokens(Map<String, ? extends Integer> entries) {
        if (this.nodePropertyTokens == entries) {
            return this;
        }
        Map<String, Integer> newValue = ImmutableGraphDimensions.createUnmodifiableMap(true, false, entries);
        return new ImmutableGraphDimensions(this, this.nodeCount, this.highestPossibleNodeCount, this.relCountUpperBound, this.relationshipCounts, this.highestRelationshipId, this.nodeLabelTokens, this.relationshipTypeTokens, this.tokenNodeLabelMapping, this.tokenRelationshipTypeMapping, newValue, this.relationshipPropertyTokens, this.estimationNodeLabelCount);
    }

    public final ImmutableGraphDimensions withRelationshipPropertyTokens(Map<String, ? extends Integer> entries) {
        if (this.relationshipPropertyTokens == entries) {
            return this;
        }
        Map<String, Integer> newValue = ImmutableGraphDimensions.createUnmodifiableMap(true, false, entries);
        return new ImmutableGraphDimensions(this, this.nodeCount, this.highestPossibleNodeCount, this.relCountUpperBound, this.relationshipCounts, this.highestRelationshipId, this.nodeLabelTokens, this.relationshipTypeTokens, this.tokenNodeLabelMapping, this.tokenRelationshipTypeMapping, this.nodePropertyTokens, newValue, this.estimationNodeLabelCount);
    }

    public final ImmutableGraphDimensions withEstimationNodeLabelCount(int value) {
        if (this.estimationNodeLabelCount == value) {
            return this;
        }
        return new ImmutableGraphDimensions(this, this.nodeCount, this.highestPossibleNodeCount, this.relCountUpperBound, this.relationshipCounts, this.highestRelationshipId, this.nodeLabelTokens, this.relationshipTypeTokens, this.tokenNodeLabelMapping, this.tokenRelationshipTypeMapping, this.nodePropertyTokens, this.relationshipPropertyTokens, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphDimensions && this.equalTo((ImmutableGraphDimensions)another);
    }

    private boolean equalTo(ImmutableGraphDimensions another) {
        return this.nodeCount == another.nodeCount && this.highestPossibleNodeCount == another.highestPossibleNodeCount && this.relCountUpperBound == another.relCountUpperBound && this.relationshipCounts.equals(another.relationshipCounts) && this.highestRelationshipId == another.highestRelationshipId && Objects.equals(this.nodeLabelTokens, another.nodeLabelTokens) && Objects.equals(this.relationshipTypeTokens, another.relationshipTypeTokens) && Objects.equals(this.tokenNodeLabelMapping, another.tokenNodeLabelMapping) && Objects.equals(this.tokenRelationshipTypeMapping, another.tokenRelationshipTypeMapping) && this.averageDegree == another.averageDegree && Objects.equals(this.relationshipTypeTokenMapping, another.relationshipTypeTokenMapping) && this.nodePropertyTokens.equals(another.nodePropertyTokens) && this.relationshipPropertyTokens.equals(another.relationshipPropertyTokens) && this.estimationNodeLabelCount == another.estimationNodeLabelCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.nodeCount);
        h += (h << 5) + Long.hashCode(this.highestPossibleNodeCount);
        h += (h << 5) + Long.hashCode(this.relCountUpperBound);
        h += (h << 5) + this.relationshipCounts.hashCode();
        h += (h << 5) + Long.hashCode(this.highestRelationshipId);
        h += (h << 5) + Objects.hashCode(this.nodeLabelTokens);
        h += (h << 5) + Objects.hashCode(this.relationshipTypeTokens);
        h += (h << 5) + Objects.hashCode(this.tokenNodeLabelMapping);
        h += (h << 5) + Objects.hashCode(this.tokenRelationshipTypeMapping);
        h += (h << 5) + Long.hashCode(this.averageDegree);
        h += (h << 5) + Objects.hashCode(this.relationshipTypeTokenMapping);
        h += (h << 5) + this.nodePropertyTokens.hashCode();
        h += (h << 5) + this.relationshipPropertyTokens.hashCode();
        h += (h << 5) + this.estimationNodeLabelCount;
        return h;
    }

    public String toString() {
        return "GraphDimensions{nodeCount=" + this.nodeCount + ", highestPossibleNodeCount=" + this.highestPossibleNodeCount + ", relCountUpperBound=" + this.relCountUpperBound + ", relationshipCounts=" + this.relationshipCounts + ", highestRelationshipId=" + this.highestRelationshipId + ", nodeLabelTokens=" + this.nodeLabelTokens + ", relationshipTypeTokens=" + this.relationshipTypeTokens + ", tokenNodeLabelMapping=" + this.tokenNodeLabelMapping + ", tokenRelationshipTypeMapping=" + this.tokenRelationshipTypeMapping + ", averageDegree=" + this.averageDegree + ", relationshipTypeTokenMapping=" + this.relationshipTypeTokenMapping + ", nodePropertyTokens=" + this.nodePropertyTokens + ", relationshipPropertyTokens=" + this.relationshipPropertyTokens + ", estimationNodeLabelCount=" + this.estimationNodeLabelCount + "}";
    }

    public static GraphDimensions of(long nodeCount, long highestPossibleNodeCount, long relCountUpperBound, Map<? extends RelationshipType, ? extends Long> relationshipCounts, long highestRelationshipId, @Nullable LongSet nodeLabelTokens, @Nullable LongSet relationshipTypeTokens, @Nullable IntObjectMap<List<NodeLabel>> tokenNodeLabelMapping, @Nullable IntObjectMap<List<RelationshipType>> tokenRelationshipTypeMapping, Map<String, ? extends Integer> nodePropertyTokens, Map<String, ? extends Integer> relationshipPropertyTokens, int estimationNodeLabelCount) {
        return new ImmutableGraphDimensions(nodeCount, highestPossibleNodeCount, relCountUpperBound, relationshipCounts, highestRelationshipId, nodeLabelTokens, relationshipTypeTokens, tokenNodeLabelMapping, tokenRelationshipTypeMapping, nodePropertyTokens, relationshipPropertyTokens, estimationNodeLabelCount);
    }

    public static GraphDimensions copyOf(GraphDimensions instance) {
        if (instance instanceof ImmutableGraphDimensions) {
            return (ImmutableGraphDimensions)instance;
        }
        return ImmutableGraphDimensions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="GraphDimensions", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NODE_COUNT = 1L;
        private static final long OPT_BIT_HIGHEST_POSSIBLE_NODE_COUNT = 1L;
        private static final long OPT_BIT_REL_COUNT_UPPER_BOUND = 2L;
        private static final long OPT_BIT_RELATIONSHIP_COUNTS = 4L;
        private static final long OPT_BIT_HIGHEST_RELATIONSHIP_ID = 8L;
        private static final long OPT_BIT_NODE_PROPERTY_TOKENS = 16L;
        private static final long OPT_BIT_RELATIONSHIP_PROPERTY_TOKENS = 32L;
        private static final long OPT_BIT_ESTIMATION_NODE_LABEL_COUNT = 64L;
        private long initBits = 1L;
        private long optBits;
        private long nodeCount;
        private long highestPossibleNodeCount;
        private long relCountUpperBound;
        private Map<RelationshipType, Long> relationshipCounts = null;
        private long highestRelationshipId;
        private LongSet nodeLabelTokens;
        private LongSet relationshipTypeTokens;
        private IntObjectMap<List<NodeLabel>> tokenNodeLabelMapping;
        private IntObjectMap<List<RelationshipType>> tokenRelationshipTypeMapping;
        private Map<String, Integer> nodePropertyTokens = null;
        private Map<String, Integer> relationshipPropertyTokens = null;
        private int estimationNodeLabelCount;

        private Builder() {
        }

        public final Builder from(GraphDimensions instance) {
            IntObjectMap<List<RelationshipType>> tokenRelationshipTypeMappingValue;
            IntObjectMap<List<NodeLabel>> tokenNodeLabelMappingValue;
            LongSet relationshipTypeTokensValue;
            Objects.requireNonNull(instance, "instance");
            this.nodeCount(instance.nodeCount());
            this.highestPossibleNodeCount(instance.highestPossibleNodeCount());
            this.relCountUpperBound(instance.relCountUpperBound());
            this.putAllRelationshipCounts(instance.relationshipCounts());
            this.highestRelationshipId(instance.highestRelationshipId());
            @Nullable LongSet nodeLabelTokensValue = instance.nodeLabelTokens();
            if (nodeLabelTokensValue != null) {
                this.nodeLabelTokens(nodeLabelTokensValue);
            }
            if ((relationshipTypeTokensValue = instance.relationshipTypeTokens()) != null) {
                this.relationshipTypeTokens(relationshipTypeTokensValue);
            }
            if ((tokenNodeLabelMappingValue = instance.tokenNodeLabelMapping()) != null) {
                this.tokenNodeLabelMapping(tokenNodeLabelMappingValue);
            }
            if ((tokenRelationshipTypeMappingValue = instance.tokenRelationshipTypeMapping()) != null) {
                this.tokenRelationshipTypeMapping(tokenRelationshipTypeMappingValue);
            }
            this.putAllNodePropertyTokens(instance.nodePropertyTokens());
            this.putAllRelationshipPropertyTokens(instance.relationshipPropertyTokens());
            this.estimationNodeLabelCount(instance.estimationNodeLabelCount());
            return this;
        }

        public final Builder nodeCount(long nodeCount) {
            this.nodeCount = nodeCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder highestPossibleNodeCount(long highestPossibleNodeCount) {
            this.highestPossibleNodeCount = highestPossibleNodeCount;
            this.optBits |= 1L;
            return this;
        }

        public final Builder relCountUpperBound(long relCountUpperBound) {
            this.relCountUpperBound = relCountUpperBound;
            this.optBits |= 2L;
            return this;
        }

        public final Builder putRelationshipCount(RelationshipType key, long value) {
            if (this.relationshipCounts == null) {
                this.relationshipCounts = new LinkedHashMap<RelationshipType, Long>();
            }
            this.relationshipCounts.put(Objects.requireNonNull(key, "relationshipCounts key"), Objects.requireNonNull(Long.valueOf(value), "relationshipCounts value"));
            this.optBits |= 4L;
            return this;
        }

        public final Builder putRelationshipCount(Map.Entry<? extends RelationshipType, ? extends Long> entry) {
            if (this.relationshipCounts == null) {
                this.relationshipCounts = new LinkedHashMap<RelationshipType, Long>();
            }
            RelationshipType k = entry.getKey();
            Long v = entry.getValue();
            this.relationshipCounts.put(Objects.requireNonNull(k, "relationshipCounts key"), Objects.requireNonNull(v, "relationshipCounts value"));
            this.optBits |= 4L;
            return this;
        }

        public final Builder relationshipCounts(Map<? extends RelationshipType, ? extends Long> entries) {
            this.relationshipCounts = new LinkedHashMap<RelationshipType, Long>();
            this.optBits |= 4L;
            return this.putAllRelationshipCounts(entries);
        }

        public final Builder putAllRelationshipCounts(Map<? extends RelationshipType, ? extends Long> entries) {
            if (this.relationshipCounts == null) {
                this.relationshipCounts = new LinkedHashMap<RelationshipType, Long>();
            }
            for (Map.Entry<? extends RelationshipType, ? extends Long> e : entries.entrySet()) {
                RelationshipType k = e.getKey();
                Long v = e.getValue();
                this.relationshipCounts.put(Objects.requireNonNull(k, "relationshipCounts key"), Objects.requireNonNull(v, "relationshipCounts value"));
            }
            this.optBits |= 4L;
            return this;
        }

        public final Builder highestRelationshipId(long highestRelationshipId) {
            this.highestRelationshipId = highestRelationshipId;
            this.optBits |= 8L;
            return this;
        }

        public final Builder nodeLabelTokens(@Nullable LongSet nodeLabelTokens) {
            this.nodeLabelTokens = nodeLabelTokens;
            return this;
        }

        public final Builder relationshipTypeTokens(@Nullable LongSet relationshipTypeTokens) {
            this.relationshipTypeTokens = relationshipTypeTokens;
            return this;
        }

        public final Builder tokenNodeLabelMapping(@Nullable IntObjectMap<List<NodeLabel>> tokenNodeLabelMapping) {
            this.tokenNodeLabelMapping = tokenNodeLabelMapping;
            return this;
        }

        public final Builder tokenRelationshipTypeMapping(@Nullable IntObjectMap<List<RelationshipType>> tokenRelationshipTypeMapping) {
            this.tokenRelationshipTypeMapping = tokenRelationshipTypeMapping;
            return this;
        }

        public final Builder putNodePropertyToken(String key, int value) {
            if (this.nodePropertyTokens == null) {
                this.nodePropertyTokens = new LinkedHashMap<String, Integer>();
            }
            this.nodePropertyTokens.put(Objects.requireNonNull(key, "nodePropertyTokens key"), Objects.requireNonNull(Integer.valueOf(value), "nodePropertyTokens value"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder putNodePropertyToken(Map.Entry<String, ? extends Integer> entry) {
            if (this.nodePropertyTokens == null) {
                this.nodePropertyTokens = new LinkedHashMap<String, Integer>();
            }
            String k = entry.getKey();
            Integer v = entry.getValue();
            this.nodePropertyTokens.put(Objects.requireNonNull(k, "nodePropertyTokens key"), Objects.requireNonNull(v, "nodePropertyTokens value"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder nodePropertyTokens(Map<String, ? extends Integer> entries) {
            this.nodePropertyTokens = new LinkedHashMap<String, Integer>();
            this.optBits |= 0x10L;
            return this.putAllNodePropertyTokens(entries);
        }

        public final Builder putAllNodePropertyTokens(Map<String, ? extends Integer> entries) {
            if (this.nodePropertyTokens == null) {
                this.nodePropertyTokens = new LinkedHashMap<String, Integer>();
            }
            for (Map.Entry<String, ? extends Integer> e : entries.entrySet()) {
                String k = e.getKey();
                Integer v = e.getValue();
                this.nodePropertyTokens.put(Objects.requireNonNull(k, "nodePropertyTokens key"), Objects.requireNonNull(v, "nodePropertyTokens value"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder putRelationshipPropertyToken(String key, int value) {
            if (this.relationshipPropertyTokens == null) {
                this.relationshipPropertyTokens = new LinkedHashMap<String, Integer>();
            }
            this.relationshipPropertyTokens.put(Objects.requireNonNull(key, "relationshipPropertyTokens key"), Objects.requireNonNull(Integer.valueOf(value), "relationshipPropertyTokens value"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder putRelationshipPropertyToken(Map.Entry<String, ? extends Integer> entry) {
            if (this.relationshipPropertyTokens == null) {
                this.relationshipPropertyTokens = new LinkedHashMap<String, Integer>();
            }
            String k = entry.getKey();
            Integer v = entry.getValue();
            this.relationshipPropertyTokens.put(Objects.requireNonNull(k, "relationshipPropertyTokens key"), Objects.requireNonNull(v, "relationshipPropertyTokens value"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder relationshipPropertyTokens(Map<String, ? extends Integer> entries) {
            this.relationshipPropertyTokens = new LinkedHashMap<String, Integer>();
            this.optBits |= 0x20L;
            return this.putAllRelationshipPropertyTokens(entries);
        }

        public final Builder putAllRelationshipPropertyTokens(Map<String, ? extends Integer> entries) {
            if (this.relationshipPropertyTokens == null) {
                this.relationshipPropertyTokens = new LinkedHashMap<String, Integer>();
            }
            for (Map.Entry<String, ? extends Integer> e : entries.entrySet()) {
                String k = e.getKey();
                Integer v = e.getValue();
                this.relationshipPropertyTokens.put(Objects.requireNonNull(k, "relationshipPropertyTokens key"), Objects.requireNonNull(v, "relationshipPropertyTokens value"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder estimationNodeLabelCount(int estimationNodeLabelCount) {
            this.estimationNodeLabelCount = estimationNodeLabelCount;
            this.optBits |= 0x40L;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.nodeCount = 0L;
            this.highestPossibleNodeCount = 0L;
            this.relCountUpperBound = 0L;
            if (this.relationshipCounts != null) {
                this.relationshipCounts.clear();
            }
            this.highestRelationshipId = 0L;
            this.nodeLabelTokens = null;
            this.relationshipTypeTokens = null;
            this.tokenNodeLabelMapping = null;
            this.tokenRelationshipTypeMapping = null;
            if (this.nodePropertyTokens != null) {
                this.nodePropertyTokens.clear();
            }
            if (this.relationshipPropertyTokens != null) {
                this.relationshipPropertyTokens.clear();
            }
            this.estimationNodeLabelCount = 0;
            return this;
        }

        public GraphDimensions build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGraphDimensions(this);
        }

        private boolean highestPossibleNodeCountIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean relCountUpperBoundIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean relationshipCountsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean highestRelationshipIdIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean nodePropertyTokensIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean relationshipPropertyTokensIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean estimationNodeLabelCountIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nodeCount");
            }
            return "Cannot build GraphDimensions, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="GraphDimensions", generator="Immutables")
    private final class InitShim {
        private byte highestPossibleNodeCountBuildStage = 0;
        private long highestPossibleNodeCount;
        private byte relCountUpperBoundBuildStage = 0;
        private long relCountUpperBound;
        private byte relationshipCountsBuildStage = 0;
        private Map<RelationshipType, Long> relationshipCounts;
        private byte highestRelationshipIdBuildStage = 0;
        private long highestRelationshipId;
        private byte averageDegreeBuildStage = 0;
        private long averageDegree;
        private byte relationshipTypeTokenMappingBuildStage = 0;
        private ObjectIntMap<RelationshipType> relationshipTypeTokenMapping;
        private byte nodePropertyTokensBuildStage = 0;
        private Map<String, Integer> nodePropertyTokens;
        private byte relationshipPropertyTokensBuildStage = 0;
        private Map<String, Integer> relationshipPropertyTokens;
        private byte estimationNodeLabelCountBuildStage = 0;
        private int estimationNodeLabelCount;

        private InitShim() {
        }

        long highestPossibleNodeCount() {
            if (this.highestPossibleNodeCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.highestPossibleNodeCountBuildStage == 0) {
                this.highestPossibleNodeCountBuildStage = (byte)-1;
                this.highestPossibleNodeCount = ImmutableGraphDimensions.this.highestPossibleNodeCountInitialize();
                this.highestPossibleNodeCountBuildStage = 1;
            }
            return this.highestPossibleNodeCount;
        }

        void highestPossibleNodeCount(long highestPossibleNodeCount) {
            this.highestPossibleNodeCount = highestPossibleNodeCount;
            this.highestPossibleNodeCountBuildStage = 1;
        }

        long relCountUpperBound() {
            if (this.relCountUpperBoundBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relCountUpperBoundBuildStage == 0) {
                this.relCountUpperBoundBuildStage = (byte)-1;
                this.relCountUpperBound = ImmutableGraphDimensions.this.relCountUpperBoundInitialize();
                this.relCountUpperBoundBuildStage = 1;
            }
            return this.relCountUpperBound;
        }

        void relCountUpperBound(long relCountUpperBound) {
            this.relCountUpperBound = relCountUpperBound;
            this.relCountUpperBoundBuildStage = 1;
        }

        Map<RelationshipType, Long> relationshipCounts() {
            if (this.relationshipCountsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipCountsBuildStage == 0) {
                this.relationshipCountsBuildStage = (byte)-1;
                this.relationshipCounts = ImmutableGraphDimensions.createUnmodifiableMap(true, false, ImmutableGraphDimensions.this.relationshipCountsInitialize());
                this.relationshipCountsBuildStage = 1;
            }
            return this.relationshipCounts;
        }

        void relationshipCounts(Map<RelationshipType, Long> relationshipCounts) {
            this.relationshipCounts = relationshipCounts;
            this.relationshipCountsBuildStage = 1;
        }

        long highestRelationshipId() {
            if (this.highestRelationshipIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.highestRelationshipIdBuildStage == 0) {
                this.highestRelationshipIdBuildStage = (byte)-1;
                this.highestRelationshipId = ImmutableGraphDimensions.this.highestRelationshipIdInitialize();
                this.highestRelationshipIdBuildStage = 1;
            }
            return this.highestRelationshipId;
        }

        void highestRelationshipId(long highestRelationshipId) {
            this.highestRelationshipId = highestRelationshipId;
            this.highestRelationshipIdBuildStage = 1;
        }

        long averageDegree() {
            if (this.averageDegreeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.averageDegreeBuildStage == 0) {
                this.averageDegreeBuildStage = (byte)-1;
                this.averageDegree = ImmutableGraphDimensions.this.averageDegreeInitialize();
                this.averageDegreeBuildStage = 1;
            }
            return this.averageDegree;
        }

        ObjectIntMap<RelationshipType> relationshipTypeTokenMapping() {
            if (this.relationshipTypeTokenMappingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypeTokenMappingBuildStage == 0) {
                this.relationshipTypeTokenMappingBuildStage = (byte)-1;
                this.relationshipTypeTokenMapping = ImmutableGraphDimensions.this.relationshipTypeTokenMappingInitialize();
                this.relationshipTypeTokenMappingBuildStage = 1;
            }
            return this.relationshipTypeTokenMapping;
        }

        Map<String, Integer> nodePropertyTokens() {
            if (this.nodePropertyTokensBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodePropertyTokensBuildStage == 0) {
                this.nodePropertyTokensBuildStage = (byte)-1;
                this.nodePropertyTokens = ImmutableGraphDimensions.createUnmodifiableMap(true, false, ImmutableGraphDimensions.this.nodePropertyTokensInitialize());
                this.nodePropertyTokensBuildStage = 1;
            }
            return this.nodePropertyTokens;
        }

        void nodePropertyTokens(Map<String, Integer> nodePropertyTokens) {
            this.nodePropertyTokens = nodePropertyTokens;
            this.nodePropertyTokensBuildStage = 1;
        }

        Map<String, Integer> relationshipPropertyTokens() {
            if (this.relationshipPropertyTokensBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipPropertyTokensBuildStage == 0) {
                this.relationshipPropertyTokensBuildStage = (byte)-1;
                this.relationshipPropertyTokens = ImmutableGraphDimensions.createUnmodifiableMap(true, false, ImmutableGraphDimensions.this.relationshipPropertyTokensInitialize());
                this.relationshipPropertyTokensBuildStage = 1;
            }
            return this.relationshipPropertyTokens;
        }

        void relationshipPropertyTokens(Map<String, Integer> relationshipPropertyTokens) {
            this.relationshipPropertyTokens = relationshipPropertyTokens;
            this.relationshipPropertyTokensBuildStage = 1;
        }

        int estimationNodeLabelCount() {
            if (this.estimationNodeLabelCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.estimationNodeLabelCountBuildStage == 0) {
                this.estimationNodeLabelCountBuildStage = (byte)-1;
                this.estimationNodeLabelCount = ImmutableGraphDimensions.this.estimationNodeLabelCountInitialize();
                this.estimationNodeLabelCountBuildStage = 1;
            }
            return this.estimationNodeLabelCount;
        }

        void estimationNodeLabelCount(int estimationNodeLabelCount) {
            this.estimationNodeLabelCount = estimationNodeLabelCount;
            this.estimationNodeLabelCountBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.highestPossibleNodeCountBuildStage == -1) {
                attributes.add("highestPossibleNodeCount");
            }
            if (this.relCountUpperBoundBuildStage == -1) {
                attributes.add("relCountUpperBound");
            }
            if (this.relationshipCountsBuildStage == -1) {
                attributes.add("relationshipCounts");
            }
            if (this.highestRelationshipIdBuildStage == -1) {
                attributes.add("highestRelationshipId");
            }
            if (this.averageDegreeBuildStage == -1) {
                attributes.add("averageDegree");
            }
            if (this.relationshipTypeTokenMappingBuildStage == -1) {
                attributes.add("relationshipTypeTokenMapping");
            }
            if (this.nodePropertyTokensBuildStage == -1) {
                attributes.add("nodePropertyTokens");
            }
            if (this.relationshipPropertyTokensBuildStage == -1) {
                attributes.add("relationshipPropertyTokens");
            }
            if (this.estimationNodeLabelCountBuildStage == -1) {
                attributes.add("estimationNodeLabelCount");
            }
            return "Cannot build GraphDimensions, attribute initializers form cycle " + attributes;
        }
    }
}

