/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core;

import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.LongSet;
import com.carrotsearch.hppc.ObjectIntHashMap;
import com.carrotsearch.hppc.ObjectIntMap;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.core.ImmutableGraphDimensions;

@ValueClass
public interface GraphDimensions {
    public static final int ANY_LABEL = -1;
    public static final int ANY_RELATIONSHIP_TYPE = -1;
    public static final int NO_SUCH_LABEL = -2;
    public static final int NO_SUCH_RELATIONSHIP_TYPE = -2;
    public static final int IGNORE = -4;

    public long nodeCount();

    public static ImmutableGraphDimensions.Builder builder() {
        return ImmutableGraphDimensions.builder();
    }

    @Value.Default
    default public long highestPossibleNodeCount() {
        return this.nodeCount();
    }

    @Value.Default
    default public long relCountUpperBound() {
        return 0L;
    }

    @Value.Default
    default public Map<RelationshipType, Long> relationshipCounts() {
        return Collections.emptyMap();
    }

    @Value.Default
    default public long highestRelationshipId() {
        return this.relCountUpperBound();
    }

    @Nullable
    public LongSet nodeLabelTokens();

    @Nullable
    public LongSet relationshipTypeTokens();

    @Nullable
    public IntObjectMap<List<NodeLabel>> tokenNodeLabelMapping();

    @Nullable
    public IntObjectMap<List<RelationshipType>> tokenRelationshipTypeMapping();

    @Value.Derived
    default public long averageDegree() {
        return this.nodeCount() == 0L ? 0L : this.relCountUpperBound() / this.nodeCount();
    }

    @Value.Derived
    @Nullable
    default public ObjectIntMap<RelationshipType> relationshipTypeTokenMapping() {
        if (this.tokenRelationshipTypeMapping() == null) {
            return null;
        }
        ObjectIntHashMap relationshipTypeTypeTokenMapping = new ObjectIntHashMap();
        this.tokenRelationshipTypeMapping().forEach(arg_0 -> GraphDimensions.lambda$relationshipTypeTokenMapping$1((ObjectIntMap)relationshipTypeTypeTokenMapping, arg_0));
        return relationshipTypeTypeTokenMapping;
    }

    @Value.Default
    default public Map<String, Integer> nodePropertyTokens() {
        return Collections.emptyMap();
    }

    @Value.Default
    default public Map<String, Integer> relationshipPropertyTokens() {
        return Collections.emptyMap();
    }

    @Value.Default
    default public int estimationNodeLabelCount() {
        HashSet nodeLabels = new HashSet();
        IntObjectMap<List<NodeLabel>> tokenNodeLabelMapping = this.tokenNodeLabelMapping();
        if (tokenNodeLabelMapping != null) {
            for (IntObjectCursor tokenToLabels : tokenNodeLabelMapping) {
                nodeLabels.addAll((Collection)tokenToLabels.value);
            }
        }
        return nodeLabels.stream().allMatch(l -> l.equals((Object)NodeLabel.ALL_NODES)) ? 0 : nodeLabels.size();
    }

    public static GraphDimensions of(long nodeCount) {
        return GraphDimensions.of(nodeCount, 0L);
    }

    public static GraphDimensions of(long nodeCount, long relationshipCount) {
        return ImmutableGraphDimensions.builder().nodeCount(nodeCount).relationshipCounts(Map.of(RelationshipType.ALL_RELATIONSHIPS, relationshipCount)).relCountUpperBound(relationshipCount).build();
    }

    default public long estimatedRelCount(List<String> relationshipTypeNames) {
        if (!relationshipTypeNames.contains("*")) {
            Map<RelationshipType, Long> relCounts = this.relationshipCounts();
            List relationshipTypes = relationshipTypeNames.stream().map(RelationshipType::of).collect(Collectors.toList());
            if (relCounts.keySet().containsAll(relationshipTypes)) {
                return relationshipTypes.stream().mapToLong(relCounts::get).sum();
            }
        }
        return this.relCountUpperBound();
    }

    private static /* synthetic */ void lambda$relationshipTypeTokenMapping$1(ObjectIntMap relationshipTypeTypeTokenMapping, IntObjectCursor cursor) {
        int typeToken = cursor.key;
        List relationshipTypes = (List)cursor.value;
        relationshipTypes.forEach(relationshipType -> relationshipTypeTypeTokenMapping.put(relationshipType, typeToken));
    }
}

