/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.AbstractProjections;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.DataClass;
import org.neo4j.gds.utils.StringFormatting;

@DataClass
@Value.Immutable(singleton=true)
public abstract class AbstractRelationshipProjections
extends AbstractProjections<RelationshipType, RelationshipProjection> {
    public static final RelationshipProjections ALL = AbstractRelationshipProjections.create(Collections.singletonMap(RelationshipType.ALL_RELATIONSHIPS, RelationshipProjection.ALL));
    public static final RelationshipProjections ALL_UNDIRECTED = AbstractRelationshipProjections.create(Collections.singletonMap(RelationshipType.ALL_RELATIONSHIPS, RelationshipProjection.ALL_UNDIRECTED));

    @Override
    public abstract Map<RelationshipType, RelationshipProjection> projections();

    public static RelationshipProjections fromObject(Object object) {
        if (object == null) {
            return AbstractRelationshipProjections.all();
        }
        if (object instanceof RelationshipProjections) {
            return (RelationshipProjections)object;
        }
        if (object instanceof String) {
            return AbstractRelationshipProjections.fromString((String)object);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return AbstractRelationshipProjections.fromMap(map);
        }
        if (object instanceof Iterable) {
            Iterable list = (Iterable)object;
            return AbstractRelationshipProjections.fromList(list);
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Cannot construct a relationship projection out of a %s", (Object[])new Object[]{object.getClass().getName()}));
    }

    public static RelationshipProjections fromString(@Nullable String typeString) {
        AbstractRelationshipProjections.validateIdentifierName(typeString);
        if (StringFormatting.isEmpty((String)typeString)) {
            AbstractRelationshipProjections.create(Collections.emptyMap());
        }
        if (typeString.equals("*")) {
            return AbstractRelationshipProjections.create(Collections.singletonMap(RelationshipType.ALL_RELATIONSHIPS, RelationshipProjection.ALL));
        }
        RelationshipType relationshipType = RelationshipType.of(typeString);
        RelationshipProjection filter = RelationshipProjection.fromString(typeString);
        return AbstractRelationshipProjections.create(Collections.singletonMap(relationshipType, filter));
    }

    public static RelationshipProjections fromMap(Map<String, ?> map) {
        LinkedHashMap<RelationshipType, RelationshipProjection> projections = new LinkedHashMap<RelationshipType, RelationshipProjection>();
        map.forEach((name, spec) -> {
            RelationshipProjection filter;
            RelationshipType relationshipType = RelationshipType.of(name);
            if (projections.put(relationshipType, filter = RelationshipProjection.fromObject(spec, relationshipType)) != null) {
                throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Duplicate key: %s", (Object[])new Object[]{name}));
            }
        });
        return AbstractRelationshipProjections.create(projections);
    }

    public static RelationshipProjections fromList(Iterable<?> items) {
        LinkedHashMap<RelationshipType, RelationshipProjection> filters = new LinkedHashMap<RelationshipType, RelationshipProjection>();
        for (Object item : items) {
            RelationshipProjections relationshipProjections = AbstractRelationshipProjections.fromObject(item);
            filters.putAll(relationshipProjections.projections());
        }
        return AbstractRelationshipProjections.create(filters);
    }

    public static RelationshipProjections single(RelationshipType relationshipType, RelationshipProjection projection) {
        return RelationshipProjections.builder().putProjection(relationshipType, projection).build();
    }

    private static RelationshipProjections create(Map<RelationshipType, RelationshipProjection> projections) {
        if (projections.isEmpty()) {
            throw new IllegalArgumentException("An empty relationship projection was given; at least one relationship type must be projected.");
        }
        return RelationshipProjections.of(projections);
    }

    public RelationshipProjection getFilter(RelationshipType relationshipType) {
        RelationshipProjection filter = this.projections().get(relationshipType);
        if (filter == null) {
            throw new IllegalArgumentException("Relationship type does not exist: " + relationshipType);
        }
        return filter;
    }

    public RelationshipProjections addPropertyMappings(PropertyMappings mappings) {
        if (!mappings.hasMappings()) {
            return RelationshipProjections.copyOf(this);
        }
        return this.modifyProjections(p -> p.withAdditionalPropertyMappings(mappings));
    }

    private RelationshipProjections modifyProjections(UnaryOperator<RelationshipProjection> operator) {
        Map<RelationshipType, RelationshipProjection> newProjections = this.projections().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (RelationshipProjection)operator.apply((RelationshipProjection)e.getValue())));
        if (newProjections.isEmpty()) {
            newProjections.put(RelationshipType.ALL_RELATIONSHIPS, (RelationshipProjection)operator.apply(RelationshipProjection.all()));
        }
        return AbstractRelationshipProjections.create(newProjections);
    }

    public String typeFilter() {
        if (this.isEmpty()) {
            return "";
        }
        return this.projections().values().stream().map(RelationshipProjection::type).distinct().collect(Collectors.joining("|"));
    }

    public boolean isEmpty() {
        return this == RelationshipProjections.of();
    }

    public static RelationshipProjections all() {
        return ALL;
    }

    public Map<String, Object> toObject() {
        LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
        this.projections().forEach((identifier, projection) -> value.put(identifier.name, projection.toObject()));
        return value;
    }

    public static Map<String, Object> toObject(AbstractRelationshipProjections relationshipProjections) {
        return relationshipProjections.toObject();
    }

    private static void validateIdentifierName(String identifier) {
        if (identifier.equals(RelationshipType.ALL_RELATIONSHIPS.name())) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"%s is a reserved node label and may not be used", (Object[])new Object[]{RelationshipType.ALL_RELATIONSHIPS.name()}));
        }
    }
}

