/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.AbstractNodeProjection;
import org.neo4j.gds.ElementProjection;
import org.neo4j.gds.PropertyMappings;

@Generated(from="AbstractNodeProjection", generator="Immutables")
public final class NodeProjection
extends AbstractNodeProjection {
    private final String label;
    private final PropertyMappings properties;

    private NodeProjection(String label, PropertyMappings properties) {
        this.label = Objects.requireNonNull(label, "label");
        this.properties = Objects.requireNonNull(properties, "properties");
    }

    private NodeProjection(Builder builder) {
        this.label = builder.label;
        this.properties = builder.properties != null ? builder.properties : Objects.requireNonNull(super.properties(), "properties");
    }

    private NodeProjection(NodeProjection original, String label, PropertyMappings properties) {
        this.label = label;
        this.properties = properties;
    }

    @Override
    public String label() {
        return this.label;
    }

    @Override
    public PropertyMappings properties() {
        return this.properties;
    }

    public final NodeProjection withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (this.label.equals(newValue)) {
            return this;
        }
        return new NodeProjection(this, newValue, this.properties);
    }

    public final NodeProjection withProperties(PropertyMappings value) {
        if (this.properties == value) {
            return this;
        }
        PropertyMappings newValue = Objects.requireNonNull(value, "properties");
        return new NodeProjection(this, this.label, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof NodeProjection && this.equalTo((NodeProjection)another);
    }

    private boolean equalTo(NodeProjection another) {
        return this.label.equals(another.label) && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return "NodeProjection{label=" + this.label + ", properties=" + this.properties + "}";
    }

    public static NodeProjection of(String label, PropertyMappings properties) {
        return new NodeProjection(label, properties);
    }

    public static NodeProjection copyOf(AbstractNodeProjection instance) {
        if (instance instanceof NodeProjection) {
            return (NodeProjection)instance;
        }
        return new AbstractNodeProjection.Builder().from(instance).build();
    }

    @Generated(from="AbstractNodeProjection", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_LABEL = 1L;
        private long initBits = 1L;
        protected String label;
        protected PropertyMappings properties;

        public Builder() {
            if (!(this instanceof AbstractNodeProjection.Builder)) {
                throw new UnsupportedOperationException("Use: new AbstractNodeProjection.Builder()");
            }
        }

        public final AbstractNodeProjection.Builder from(ElementProjection instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (AbstractNodeProjection.Builder)this;
        }

        public final AbstractNodeProjection.Builder from(AbstractNodeProjection instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (AbstractNodeProjection.Builder)this;
        }

        private void from(Object object) {
            ElementProjection instance;
            long bits = 0L;
            if (object instanceof ElementProjection) {
                instance = (ElementProjection)object;
                if ((bits & 1L) == 0L) {
                    this.properties(instance.properties());
                    bits |= 1L;
                }
            }
            if (object instanceof AbstractNodeProjection) {
                instance = (AbstractNodeProjection)object;
                if ((bits & 1L) == 0L) {
                    this.properties(((AbstractNodeProjection)instance).properties());
                    bits |= 1L;
                }
                this.label(((AbstractNodeProjection)instance).label());
            }
        }

        public final AbstractNodeProjection.Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (AbstractNodeProjection.Builder)this;
        }

        public final AbstractNodeProjection.Builder properties(PropertyMappings properties) {
            this.properties = Objects.requireNonNull(properties, "properties");
            return (AbstractNodeProjection.Builder)this;
        }

        public AbstractNodeProjection.Builder clear() {
            this.initBits = 1L;
            this.label = null;
            this.properties = null;
            return (AbstractNodeProjection.Builder)this;
        }

        public NodeProjection build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new NodeProjection(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("label");
            }
            return "Cannot build NodeProjection, some of required attributes are not set " + attributes;
        }
    }
}

