/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.AbstractNodeProjections;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.NodeProjection;

@Generated(from="AbstractNodeProjections", generator="Immutables")
public final class NodeProjections
extends AbstractNodeProjections {
    private final Map<NodeLabel, NodeProjection> projections;
    private static final NodeProjections INSTANCE = NodeProjections.validate(new NodeProjections());

    private NodeProjections() {
        this.projections = Collections.emptyMap();
    }

    private NodeProjections(Map<? extends NodeLabel, ? extends NodeProjection> projections) {
        this.projections = NodeProjections.createUnmodifiableMap(true, false, projections);
    }

    private NodeProjections(NodeProjections original, Map<NodeLabel, NodeProjection> projections) {
        this.projections = projections;
    }

    @Override
    public Map<NodeLabel, NodeProjection> projections() {
        return this.projections;
    }

    public final NodeProjections withProjections(Map<? extends NodeLabel, ? extends NodeProjection> entries) {
        if (this.projections == entries) {
            return this;
        }
        Map<NodeLabel, NodeProjection> newValue = NodeProjections.createUnmodifiableMap(true, false, entries);
        return NodeProjections.validate(new NodeProjections(this, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof NodeProjections && this.equalTo((NodeProjections)another);
    }

    private boolean equalTo(NodeProjections another) {
        return this.projections.equals(another.projections);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.projections.hashCode();
        return h;
    }

    public String toString() {
        return "NodeProjections{projections=" + this.projections + "}";
    }

    public static NodeProjections of() {
        return INSTANCE;
    }

    public static NodeProjections of(Map<? extends NodeLabel, ? extends NodeProjection> projections) {
        return NodeProjections.validate(new NodeProjections(projections));
    }

    private static NodeProjections validate(NodeProjections instance) {
        instance.validatePropertyKeyMappings();
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static NodeProjections copyOf(AbstractNodeProjections instance) {
        if (instance instanceof NodeProjections) {
            return (NodeProjections)instance;
        }
        return NodeProjections.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="AbstractNodeProjections", generator="Immutables")
    public static final class Builder {
        private Map<NodeLabel, NodeProjection> projections = null;

        private Builder() {
        }

        public final Builder from(AbstractNodeProjections instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllProjections(instance.projections());
            return this;
        }

        public final Builder putProjection(NodeLabel key, NodeProjection value) {
            if (this.projections == null) {
                this.projections = new LinkedHashMap<NodeLabel, NodeProjection>();
            }
            this.projections.put(Objects.requireNonNull(key, "projections key"), Objects.requireNonNull(value, "projections value"));
            return this;
        }

        public final Builder putProjection(Map.Entry<? extends NodeLabel, ? extends NodeProjection> entry) {
            if (this.projections == null) {
                this.projections = new LinkedHashMap<NodeLabel, NodeProjection>();
            }
            NodeLabel k = entry.getKey();
            NodeProjection v = entry.getValue();
            this.projections.put(Objects.requireNonNull(k, "projections key"), Objects.requireNonNull(v, "projections value"));
            return this;
        }

        public final Builder projections(Map<? extends NodeLabel, ? extends NodeProjection> entries) {
            this.projections = new LinkedHashMap<NodeLabel, NodeProjection>();
            return this.putAllProjections(entries);
        }

        public final Builder putAllProjections(Map<? extends NodeLabel, ? extends NodeProjection> entries) {
            if (this.projections == null) {
                this.projections = new LinkedHashMap<NodeLabel, NodeProjection>();
            }
            for (Map.Entry<? extends NodeLabel, ? extends NodeProjection> e : entries.entrySet()) {
                NodeLabel k = e.getKey();
                NodeProjection v = e.getValue();
                this.projections.put(Objects.requireNonNull(k, "projections key"), Objects.requireNonNull(v, "projections value"));
            }
            return this;
        }

        public Builder clear() {
            if (this.projections != null) {
                this.projections.clear();
            }
            return this;
        }

        public NodeProjections build() {
            return NodeProjections.validate(new NodeProjections(null, this.projections == null ? Collections.emptyMap() : NodeProjections.createUnmodifiableMap(false, false, this.projections)));
        }
    }
}

