/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.neo4j.gds.utils.StringFormatting;

public enum Aggregation {
    DEFAULT{

        @Override
        public double merge(double runningTotal, double value) {
            throw new UnsupportedOperationException("This should never be used as a valid aggregation, just as a placeholder for the default aggregation of a given loader.");
        }
    }
    ,
    NONE{

        @Override
        public double merge(double runningTotal, double value) {
            throw new UnsupportedOperationException("Multiple relationships between the same pair of nodes are not expected. Try using SINGLE or some other aggregation.");
        }
    }
    ,
    SINGLE{

        @Override
        public double merge(double runningTotal, double value) {
            return runningTotal;
        }
    }
    ,
    SUM{

        @Override
        public double merge(double runningTotal, double value) {
            return runningTotal + value;
        }

        @Override
        public double emptyValue(double mappingDefaultValue) {
            return Double.isNaN(mappingDefaultValue) ? 0.0 : mappingDefaultValue;
        }
    }
    ,
    MIN{

        @Override
        public double merge(double runningTotal, double value) {
            return Math.min(runningTotal, value);
        }

        @Override
        public double emptyValue(double mappingDefaultValue) {
            return Double.isNaN(mappingDefaultValue) ? Double.POSITIVE_INFINITY : mappingDefaultValue;
        }
    }
    ,
    MAX{

        @Override
        public double merge(double runningTotal, double value) {
            return Math.max(runningTotal, value);
        }

        @Override
        public double emptyValue(double mappingDefaultValue) {
            return Double.isNaN(mappingDefaultValue) ? Double.NEGATIVE_INFINITY : mappingDefaultValue;
        }
    }
    ,
    COUNT{

        @Override
        public double merge(double runningTotal, double value) {
            return runningTotal + value;
        }

        @Override
        public double normalizePropertyValue(double value) {
            return 1.0;
        }

        @Override
        public double emptyValue(double mappingDefaultValue) {
            return 0.0;
        }
    };

    private static final List<String> VALUES;

    public abstract double merge(double var1, double var3);

    public double normalizePropertyValue(double value) {
        return value;
    }

    public double emptyValue(double mappingDefaultValue) {
        return mappingDefaultValue;
    }

    public static Aggregation parse(Object input) {
        if (input instanceof String) {
            String inputString = StringFormatting.toUpperCaseWithLocale((String)((String)input));
            if (VALUES.contains(inputString)) {
                return Aggregation.valueOf(inputString.toUpperCase(Locale.ENGLISH));
            }
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Aggregation `%s` is not supported. Must be one of: %s.", (Object[])new Object[]{inputString, VALUES}));
        }
        if (input instanceof Aggregation) {
            return (Aggregation)((Object)input);
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Expected Aggregation or String. Got %s.", (Object[])new Object[]{input.getClass().getSimpleName()}));
    }

    public static Aggregation resolve(Aggregation aggregation) {
        return aggregation == DEFAULT ? NONE : aggregation;
    }

    public static String toString(Aggregation aggregation) {
        return aggregation.toString();
    }

    public static boolean equivalentToNone(Aggregation aggregation) {
        return Aggregation.resolve(aggregation) == NONE;
    }

    static {
        VALUES = Arrays.stream(Aggregation.values()).map(Enum::name).collect(Collectors.toList());
    }
}

