/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.api.schema.ElementSchemaEntry;
import org.neo4j.gds.api.schema.PropertySchema;

public interface ElementSchema<SELF extends ElementSchema<SELF, ELEMENT_IDENTIFIER, ENTRY, PROPERTY_SCHEMA>, ELEMENT_IDENTIFIER extends ElementIdentifier, ENTRY extends ElementSchemaEntry<ENTRY, ELEMENT_IDENTIFIER, PROPERTY_SCHEMA>, PROPERTY_SCHEMA extends PropertySchema> {
    public SELF filter(Set<ELEMENT_IDENTIFIER> var1);

    public SELF union(SELF var1);

    public Collection<ENTRY> entries();

    public ENTRY get(ELEMENT_IDENTIFIER var1);

    default public Set<String> allProperties() {
        return this.entries().stream().flatMap(entry -> entry.properties().keySet().stream()).collect(Collectors.toSet());
    }

    default public Set<String> allProperties(ELEMENT_IDENTIFIER elementIdentifier) {
        return Optional.ofNullable(this.get(elementIdentifier)).map(entry -> entry.properties().keySet()).orElse(Set.of());
    }

    default public boolean hasProperties() {
        return this.entries().stream().anyMatch(entry -> !entry.properties().isEmpty());
    }

    default public boolean hasProperty(ELEMENT_IDENTIFIER elementIdentifier, String propertyKey) {
        return Optional.ofNullable(this.get(elementIdentifier)).map(entry -> entry.properties().containsKey(propertyKey)).orElse(false);
    }

    default public List<PROPERTY_SCHEMA> propertySchemasFor(ELEMENT_IDENTIFIER elementIdentifier) {
        return Optional.ofNullable(this.get(elementIdentifier)).map(entry -> entry.properties().values()).map(ArrayList::new).orElse(new ArrayList());
    }

    default public Map<String, PROPERTY_SCHEMA> unionProperties() {
        return this.entries().stream().flatMap(e -> e.properties().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (leftSchema, rightSchema) -> leftSchema));
    }

    default public Map<String, Object> toMap() {
        return this.entries().stream().collect(Collectors.toMap(entry -> ((ElementIdentifier)entry.identifier()).name, ElementSchemaEntry::toMap));
    }

    default public Map<ELEMENT_IDENTIFIER, ENTRY> unionEntries(SELF other) {
        return Stream.concat(this.entries().stream(), other.entries().stream()).collect(Collectors.toMap(ElementSchemaEntry::identifier, Function.identity(), ElementSchemaEntry::union));
    }
}

