/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.api.schema.MutableGraphSchema;
import org.neo4j.gds.api.schema.MutableNodeSchema;
import org.neo4j.gds.api.schema.MutableRelationshipSchema;
import org.neo4j.gds.api.schema.PropertySchema;

@Generated(from="MutableGraphSchema", generator="Immutables")
public final class ImmutableMutableGraphSchema
implements MutableGraphSchema {
    private final Map<String, PropertySchema> graphProperties;
    private final MutableNodeSchema nodeSchema;
    private final MutableRelationshipSchema relationshipSchema;

    private ImmutableMutableGraphSchema(Map<String, ? extends PropertySchema> graphProperties, MutableNodeSchema nodeSchema, MutableRelationshipSchema relationshipSchema) {
        this.graphProperties = ImmutableMutableGraphSchema.createUnmodifiableMap(true, false, graphProperties);
        this.nodeSchema = Objects.requireNonNull(nodeSchema, "nodeSchema");
        this.relationshipSchema = Objects.requireNonNull(relationshipSchema, "relationshipSchema");
    }

    private ImmutableMutableGraphSchema(ImmutableMutableGraphSchema original, Map<String, PropertySchema> graphProperties, MutableNodeSchema nodeSchema, MutableRelationshipSchema relationshipSchema) {
        this.graphProperties = graphProperties;
        this.nodeSchema = nodeSchema;
        this.relationshipSchema = relationshipSchema;
    }

    @Override
    public Map<String, PropertySchema> graphProperties() {
        return this.graphProperties;
    }

    @Override
    public MutableNodeSchema nodeSchema() {
        return this.nodeSchema;
    }

    @Override
    public MutableRelationshipSchema relationshipSchema() {
        return this.relationshipSchema;
    }

    public final ImmutableMutableGraphSchema withGraphProperties(Map<String, ? extends PropertySchema> entries) {
        if (this.graphProperties == entries) {
            return this;
        }
        Map<String, PropertySchema> newValue = ImmutableMutableGraphSchema.createUnmodifiableMap(true, false, entries);
        return new ImmutableMutableGraphSchema(this, newValue, this.nodeSchema, this.relationshipSchema);
    }

    public final ImmutableMutableGraphSchema withNodeSchema(MutableNodeSchema value) {
        if (this.nodeSchema == value) {
            return this;
        }
        MutableNodeSchema newValue = Objects.requireNonNull(value, "nodeSchema");
        return new ImmutableMutableGraphSchema(this, this.graphProperties, newValue, this.relationshipSchema);
    }

    public final ImmutableMutableGraphSchema withRelationshipSchema(MutableRelationshipSchema value) {
        if (this.relationshipSchema == value) {
            return this;
        }
        MutableRelationshipSchema newValue = Objects.requireNonNull(value, "relationshipSchema");
        return new ImmutableMutableGraphSchema(this, this.graphProperties, this.nodeSchema, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMutableGraphSchema && this.equalTo((ImmutableMutableGraphSchema)another);
    }

    private boolean equalTo(ImmutableMutableGraphSchema another) {
        return this.graphProperties.equals(another.graphProperties) && this.nodeSchema.equals(another.nodeSchema) && this.relationshipSchema.equals(another.relationshipSchema);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.graphProperties.hashCode();
        h += (h << 5) + this.nodeSchema.hashCode();
        h += (h << 5) + this.relationshipSchema.hashCode();
        return h;
    }

    public String toString() {
        return "MutableGraphSchema{graphProperties=" + this.graphProperties + ", nodeSchema=" + this.nodeSchema + ", relationshipSchema=" + this.relationshipSchema + "}";
    }

    public static MutableGraphSchema of(Map<String, ? extends PropertySchema> graphProperties, MutableNodeSchema nodeSchema, MutableRelationshipSchema relationshipSchema) {
        return new ImmutableMutableGraphSchema(graphProperties, nodeSchema, relationshipSchema);
    }

    public static MutableGraphSchema copyOf(MutableGraphSchema instance) {
        if (instance instanceof ImmutableMutableGraphSchema) {
            return (ImmutableMutableGraphSchema)instance;
        }
        return ImmutableMutableGraphSchema.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="MutableGraphSchema", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NODE_SCHEMA = 1L;
        private static final long INIT_BIT_RELATIONSHIP_SCHEMA = 2L;
        private long initBits = 3L;
        private Map<String, PropertySchema> graphProperties = null;
        private MutableNodeSchema nodeSchema;
        private MutableRelationshipSchema relationshipSchema;

        private Builder() {
        }

        public final Builder from(MutableGraphSchema instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GraphSchema instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GraphSchema instance;
            if (object instanceof MutableGraphSchema) {
                instance = (MutableGraphSchema)object;
                this.nodeSchema(instance.nodeSchema());
                this.relationshipSchema(instance.relationshipSchema());
            }
            if (object instanceof GraphSchema) {
                instance = (GraphSchema)object;
                this.putAllGraphProperties(instance.graphProperties());
            }
        }

        public final Builder putGraphProperty(String key, PropertySchema value) {
            if (this.graphProperties == null) {
                this.graphProperties = new LinkedHashMap<String, PropertySchema>();
            }
            this.graphProperties.put(Objects.requireNonNull(key, "graphProperties key"), Objects.requireNonNull(value, "graphProperties value"));
            return this;
        }

        public final Builder putGraphProperty(Map.Entry<String, ? extends PropertySchema> entry) {
            if (this.graphProperties == null) {
                this.graphProperties = new LinkedHashMap<String, PropertySchema>();
            }
            String k = entry.getKey();
            PropertySchema v = entry.getValue();
            this.graphProperties.put(Objects.requireNonNull(k, "graphProperties key"), Objects.requireNonNull(v, "graphProperties value"));
            return this;
        }

        public final Builder graphProperties(Map<String, ? extends PropertySchema> entries) {
            this.graphProperties = new LinkedHashMap<String, PropertySchema>();
            return this.putAllGraphProperties(entries);
        }

        public final Builder putAllGraphProperties(Map<String, ? extends PropertySchema> entries) {
            if (this.graphProperties == null) {
                this.graphProperties = new LinkedHashMap<String, PropertySchema>();
            }
            for (Map.Entry<String, ? extends PropertySchema> e : entries.entrySet()) {
                String k = e.getKey();
                PropertySchema v = e.getValue();
                this.graphProperties.put(Objects.requireNonNull(k, "graphProperties key"), Objects.requireNonNull(v, "graphProperties value"));
            }
            return this;
        }

        public final Builder nodeSchema(MutableNodeSchema nodeSchema) {
            this.nodeSchema = Objects.requireNonNull(nodeSchema, "nodeSchema");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder relationshipSchema(MutableRelationshipSchema relationshipSchema) {
            this.relationshipSchema = Objects.requireNonNull(relationshipSchema, "relationshipSchema");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            if (this.graphProperties != null) {
                this.graphProperties.clear();
            }
            this.nodeSchema = null;
            this.relationshipSchema = null;
            return this;
        }

        public MutableGraphSchema build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMutableGraphSchema(null, this.graphProperties == null ? Collections.emptyMap() : ImmutableMutableGraphSchema.createUnmodifiableMap(false, false, this.graphProperties), this.nodeSchema, this.relationshipSchema);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nodeSchema");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("relationshipSchema");
            }
            return "Cannot build MutableGraphSchema, some of required attributes are not set " + attributes;
        }
    }
}

