/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.PropertyState;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.schema.PropertySchema;

@Generated(from="PropertySchema", generator="Immutables")
public final class ImmutablePropertySchema
implements PropertySchema {
    private final String key;
    private final ValueType valueType;
    private final DefaultValue defaultValue;
    private final PropertyState state;

    private ImmutablePropertySchema(String key, ValueType valueType, DefaultValue defaultValue, PropertyState state) {
        this.key = Objects.requireNonNull(key, "key");
        this.valueType = Objects.requireNonNull(valueType, "valueType");
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
        this.state = Objects.requireNonNull(state, "state");
    }

    private ImmutablePropertySchema(ImmutablePropertySchema original, String key, ValueType valueType, DefaultValue defaultValue, PropertyState state) {
        this.key = key;
        this.valueType = valueType;
        this.defaultValue = defaultValue;
        this.state = state;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public ValueType valueType() {
        return this.valueType;
    }

    @Override
    public DefaultValue defaultValue() {
        return this.defaultValue;
    }

    @Override
    public PropertyState state() {
        return this.state;
    }

    public final ImmutablePropertySchema withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutablePropertySchema(this, newValue, this.valueType, this.defaultValue, this.state);
    }

    public final ImmutablePropertySchema withValueType(ValueType value) {
        if (this.valueType == value) {
            return this;
        }
        ValueType newValue = Objects.requireNonNull(value, "valueType");
        if (this.valueType.equals((Object)newValue)) {
            return this;
        }
        return new ImmutablePropertySchema(this, this.key, newValue, this.defaultValue, this.state);
    }

    public final ImmutablePropertySchema withDefaultValue(DefaultValue value) {
        if (this.defaultValue == value) {
            return this;
        }
        DefaultValue newValue = Objects.requireNonNull(value, "defaultValue");
        return new ImmutablePropertySchema(this, this.key, this.valueType, newValue, this.state);
    }

    public final ImmutablePropertySchema withState(PropertyState value) {
        if (this.state == value) {
            return this;
        }
        PropertyState newValue = Objects.requireNonNull(value, "state");
        if (this.state.equals((Object)newValue)) {
            return this;
        }
        return new ImmutablePropertySchema(this, this.key, this.valueType, this.defaultValue, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePropertySchema && this.equalTo((ImmutablePropertySchema)another);
    }

    private boolean equalTo(ImmutablePropertySchema another) {
        return this.key.equals(another.key) && this.valueType.equals((Object)another.valueType) && this.defaultValue.equals((Object)another.defaultValue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.valueType.hashCode();
        h += (h << 5) + this.defaultValue.hashCode();
        return h;
    }

    public String toString() {
        return "PropertySchema{key=" + this.key + ", valueType=" + this.valueType + ", defaultValue=" + this.defaultValue + "}";
    }

    public static PropertySchema of(String key, ValueType valueType, DefaultValue defaultValue, PropertyState state) {
        return new ImmutablePropertySchema(key, valueType, defaultValue, state);
    }

    public static PropertySchema copyOf(PropertySchema instance) {
        if (instance instanceof ImmutablePropertySchema) {
            return (ImmutablePropertySchema)instance;
        }
        return ImmutablePropertySchema.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PropertySchema", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_VALUE_TYPE = 2L;
        private static final long INIT_BIT_DEFAULT_VALUE = 4L;
        private static final long INIT_BIT_STATE = 8L;
        private long initBits = 15L;
        private String key;
        private ValueType valueType;
        private DefaultValue defaultValue;
        private PropertyState state;

        private Builder() {
        }

        public final Builder from(PropertySchema instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.key());
            this.valueType(instance.valueType());
            this.defaultValue(instance.defaultValue());
            this.state(instance.state());
            return this;
        }

        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder valueType(ValueType valueType) {
            this.valueType = Objects.requireNonNull(valueType, "valueType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder defaultValue(DefaultValue defaultValue) {
            this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder state(PropertyState state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Builder clear() {
            this.initBits = 15L;
            this.key = null;
            this.valueType = null;
            this.defaultValue = null;
            this.state = null;
            return this;
        }

        public PropertySchema build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePropertySchema(null, this.key, this.valueType, this.defaultValue, this.state);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("valueType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("defaultValue");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("state");
            }
            return "Cannot build PropertySchema, some of required attributes are not set " + attributes;
        }
    }
}

