/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.api.schema.ImmutableMutableGraphSchema;
import org.neo4j.gds.api.schema.MutableNodeSchema;
import org.neo4j.gds.api.schema.MutableRelationshipSchema;
import org.neo4j.gds.api.schema.PropertySchema;

@ValueClass
public interface MutableGraphSchema
extends GraphSchema {
    @Override
    public MutableNodeSchema nodeSchema();

    @Override
    public MutableRelationshipSchema relationshipSchema();

    @Override
    default public MutableGraphSchema filterNodeLabels(Set<NodeLabel> labelsToKeep) {
        return MutableGraphSchema.of((MutableNodeSchema)this.nodeSchema().filter((Set)labelsToKeep), this.relationshipSchema(), this.graphProperties());
    }

    @Override
    default public MutableGraphSchema filterRelationshipTypes(Set<RelationshipType> relationshipTypesToKeep) {
        return MutableGraphSchema.of(this.nodeSchema(), (MutableRelationshipSchema)this.relationshipSchema().filter((Set)relationshipTypesToKeep), this.graphProperties());
    }

    @Override
    default public MutableGraphSchema union(GraphSchema other) {
        return MutableGraphSchema.of(this.nodeSchema().union(other.nodeSchema()), this.relationshipSchema().union(other.relationshipSchema()), this.unionGraphProperties(other.graphProperties()));
    }

    public static MutableGraphSchema empty() {
        return MutableGraphSchema.of(MutableNodeSchema.empty(), MutableRelationshipSchema.empty(), Map.of());
    }

    public static MutableGraphSchema from(GraphSchema from) {
        return MutableGraphSchema.of(MutableNodeSchema.from(from.nodeSchema()), MutableRelationshipSchema.from(from.relationshipSchema()), new HashMap<String, PropertySchema>(from.graphProperties()));
    }

    public static MutableGraphSchema of(MutableNodeSchema nodeSchema, MutableRelationshipSchema relationshipSchema, Map<String, PropertySchema> graphProperties) {
        return ImmutableMutableGraphSchema.builder().nodeSchema(nodeSchema).relationshipSchema(relationshipSchema).graphProperties(graphProperties).build();
    }

    public static ImmutableMutableGraphSchema.Builder builder() {
        return ImmutableMutableGraphSchema.builder();
    }

    private Map<String, PropertySchema> unionGraphProperties(Map<String, PropertySchema> otherProperties) {
        return Stream.concat(this.graphProperties().entrySet().stream(), otherProperties.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (leftType, rightType) -> {
            if (leftType.valueType() != rightType.valueType()) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Combining schema entries with value type %s and %s is not supported.", leftType.valueType(), rightType.valueType()));
            }
            return leftType;
        }));
    }
}

