/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.PropertyState;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.schema.Direction;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.api.schema.MutableRelationshipSchemaEntry;
import org.neo4j.gds.api.schema.RelationshipPropertySchema;
import org.neo4j.gds.api.schema.RelationshipSchema;
import org.neo4j.gds.api.schema.RelationshipSchemaEntry;

public class MutableRelationshipSchema
implements RelationshipSchema {
    private final Map<RelationshipType, MutableRelationshipSchemaEntry> entries;

    public static MutableRelationshipSchema empty() {
        return new MutableRelationshipSchema(new LinkedHashMap<RelationshipType, MutableRelationshipSchemaEntry>());
    }

    public MutableRelationshipSchema(Map<RelationshipType, MutableRelationshipSchemaEntry> entries) {
        this.entries = entries;
    }

    public static MutableRelationshipSchema from(RelationshipSchema fromSchema) {
        MutableRelationshipSchema relationshipSchema = MutableRelationshipSchema.empty();
        fromSchema.entries().forEach(fromEntry -> relationshipSchema.set(MutableRelationshipSchemaEntry.from(fromEntry)));
        return relationshipSchema;
    }

    @Override
    public MutableRelationshipSchema filter(Set<RelationshipType> relationshipTypesToKeep) {
        return new MutableRelationshipSchema(this.entries.entrySet().stream().filter((? super T e) -> relationshipTypesToKeep.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> MutableRelationshipSchemaEntry.from((RelationshipSchemaEntry)entry.getValue()))));
    }

    @Override
    public MutableRelationshipSchema union(RelationshipSchema other) {
        return new MutableRelationshipSchema(this.unionEntries(other));
    }

    @Override
    public Collection<MutableRelationshipSchemaEntry> entries() {
        return this.entries.values();
    }

    @Override
    public MutableRelationshipSchemaEntry get(RelationshipType identifier) {
        return this.entries.get(identifier);
    }

    @Override
    public Set<RelationshipType> availableTypes() {
        return this.entries.keySet();
    }

    @Override
    public boolean isUndirected() {
        return this.entries.values().stream().allMatch(MutableRelationshipSchemaEntry::isUndirected);
    }

    @Override
    public boolean isUndirected(RelationshipType type) {
        return this.entries.get(type).isUndirected();
    }

    @Override
    public Map<RelationshipType, Direction> directions() {
        return this.availableTypes().stream().collect(Collectors.toMap(relationshipType -> relationshipType, relationshipType -> this.entries.get(relationshipType).direction()));
    }

    @Override
    public Object toMapOld() {
        return this.entries().stream().collect(Collectors.toMap(e -> e.identifier().name(), e -> e.properties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, innerEntry -> GraphSchema.forPropertySchema((RelationshipPropertySchema)innerEntry.getValue())))));
    }

    public void set(MutableRelationshipSchemaEntry entry) {
        this.entries.put(entry.identifier(), entry);
    }

    public void remove(RelationshipType identifier) {
        this.entries.remove(identifier);
    }

    public MutableRelationshipSchemaEntry getOrCreateRelationshipType(RelationshipType relationshipType, Direction direction) {
        return this.entries.computeIfAbsent(relationshipType, __ -> new MutableRelationshipSchemaEntry(relationshipType, direction));
    }

    public MutableRelationshipSchema addRelationshipType(RelationshipType relationshipType, Direction direction) {
        this.getOrCreateRelationshipType(relationshipType, direction);
        return this;
    }

    public MutableRelationshipSchema addProperty(RelationshipType relationshipType, Direction direction, String propertyKey, RelationshipPropertySchema propertySchema) {
        this.getOrCreateRelationshipType(relationshipType, direction).addProperty(propertyKey, propertySchema);
        return this;
    }

    public MutableRelationshipSchema addProperty(RelationshipType relationshipType, Direction direction, String propertyKey, ValueType valueType, PropertyState propertyState) {
        this.getOrCreateRelationshipType(relationshipType, direction).addProperty(propertyKey, valueType, propertyState);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableRelationshipSchema that = (MutableRelationshipSchema)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }
}

