/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.PropertyState;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.schema.Direction;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.api.schema.RelationshipPropertySchema;
import org.neo4j.gds.api.schema.RelationshipSchemaEntry;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.utils.StringFormatting;

public class MutableRelationshipSchemaEntry
implements RelationshipSchemaEntry {
    private final RelationshipType relationshipType;
    private final Direction direction;
    private final Map<String, RelationshipPropertySchema> properties;

    public MutableRelationshipSchemaEntry(RelationshipType identifier, Direction direction) {
        this(identifier, direction, new LinkedHashMap<String, RelationshipPropertySchema>());
    }

    public MutableRelationshipSchemaEntry(RelationshipType relationshipType, Direction direction, Map<String, RelationshipPropertySchema> properties) {
        this.relationshipType = relationshipType;
        this.direction = direction;
        this.properties = properties;
    }

    public static MutableRelationshipSchemaEntry from(RelationshipSchemaEntry fromEntry) {
        return new MutableRelationshipSchemaEntry((RelationshipType)fromEntry.identifier(), fromEntry.direction(), new HashMap<String, RelationshipPropertySchema>(fromEntry.properties()));
    }

    @Override
    public Direction direction() {
        return this.direction;
    }

    @Override
    public boolean isUndirected() {
        return this.direction() == Direction.UNDIRECTED;
    }

    @Override
    public RelationshipType identifier() {
        return this.relationshipType;
    }

    @Override
    public Map<String, RelationshipPropertySchema> properties() {
        return Map.copyOf(this.properties);
    }

    @Override
    public MutableRelationshipSchemaEntry union(MutableRelationshipSchemaEntry other) {
        if (!other.identifier().equals((Object)this.identifier())) {
            throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Cannot union relationship schema entries with different types %s and %s", (Object[])new Object[]{this.identifier(), other.identifier()}));
        }
        if (other.isUndirected() != this.isUndirected()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Conflicting directionality for relationship types %s", (Object[])new Object[]{this.identifier().name}));
        }
        return new MutableRelationshipSchemaEntry(this.identifier(), this.direction, this.unionProperties(other.properties));
    }

    @Override
    public Map<String, Object> toMap() {
        return Map.of("direction", this.direction.name(), "properties", this.properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, innerEntry -> GraphSchema.forPropertySchema((RelationshipPropertySchema)innerEntry.getValue()))));
    }

    public MutableRelationshipSchemaEntry addProperty(String propertyKey, ValueType valueType, PropertyState propertyState) {
        return this.addProperty(propertyKey, RelationshipPropertySchema.of(propertyKey, valueType, valueType.fallbackValue(), propertyState, Aggregation.DEFAULT));
    }

    public MutableRelationshipSchemaEntry addProperty(String propertyKey, RelationshipPropertySchema propertySchema) {
        this.properties.put(propertyKey, propertySchema);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableRelationshipSchemaEntry that = (MutableRelationshipSchemaEntry)o;
        if (!this.relationshipType.equals((Object)that.relationshipType)) {
            return false;
        }
        if (this.direction != that.direction) {
            return false;
        }
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        int result = this.relationshipType.hashCode();
        result = 31 * result + this.direction.hashCode();
        result = 31 * result + this.properties.hashCode();
        return result;
    }
}

