/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import org.immutables.value.Value;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.PropertyState;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.schema.ImmutablePropertySchema;

@ValueClass
public interface PropertySchema {
    public String key();

    public ValueType valueType();

    public DefaultValue defaultValue();

    @Value.Auxiliary
    public PropertyState state();

    public static PropertySchema of(String propertyKey, ValueType valueType) {
        return ImmutablePropertySchema.of(propertyKey, valueType, valueType.fallbackValue(), PropertyState.PERSISTENT);
    }

    public static PropertySchema of(String propertyKey, ValueType valueType, DefaultValue defaultValue, PropertyState propertyState) {
        return ImmutablePropertySchema.of(propertyKey, valueType, defaultValue, propertyState);
    }
}

