/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import org.immutables.value.Value;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.PropertyState;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.schema.ImmutableRelationshipPropertySchema;
import org.neo4j.gds.api.schema.PropertySchema;
import org.neo4j.gds.core.Aggregation;

@ValueClass
public interface RelationshipPropertySchema
extends PropertySchema {
    public Aggregation aggregation();

    public static RelationshipPropertySchema of(String propertyKey, ValueType valueType) {
        return ImmutableRelationshipPropertySchema.of(propertyKey, valueType, valueType.fallbackValue(), PropertyState.PERSISTENT, Aggregation.DEFAULT);
    }

    public static RelationshipPropertySchema of(String propertyKey, ValueType valueType, Aggregation aggregation) {
        return ImmutableRelationshipPropertySchema.of(propertyKey, valueType, valueType.fallbackValue(), PropertyState.PERSISTENT, aggregation);
    }

    public static RelationshipPropertySchema of(String propertyKey, ValueType valueType, DefaultValue defaultValue, PropertyState propertyState, Aggregation aggregation) {
        return ImmutableRelationshipPropertySchema.of(propertyKey, valueType, defaultValue, propertyState, aggregation);
    }

    @Value.Check
    default public RelationshipPropertySchema normalize() {
        if (this.aggregation() == Aggregation.DEFAULT) {
            return ImmutableRelationshipPropertySchema.builder().from(this).aggregation(Aggregation.resolve((Aggregation)this.aggregation())).build();
        }
        return this;
    }
}

