/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.decisiontree;

import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.ReadOnlyHugeLongArray;
import org.neo4j.gds.decisiontree.DecisionTreeLoss;
import org.neo4j.gds.decisiontree.DecisionTreeTrain;
import org.neo4j.gds.decisiontree.DecisionTreeTrainConfig;
import org.neo4j.gds.decisiontree.FeatureBagger;
import org.neo4j.gds.ml.core.subgraph.LocalIdMap;
import org.neo4j.gds.models.Features;

public class ClassificationDecisionTreeTrain<LOSS extends DecisionTreeLoss>
extends DecisionTreeTrain<LOSS, Integer> {
    private final HugeLongArray allLabels;
    private final LocalIdMap classIdMap;

    public ClassificationDecisionTreeTrain(LOSS lossFunction, Features features, HugeLongArray labels, LocalIdMap classIdMap, DecisionTreeTrainConfig config, FeatureBagger featureBagger) {
        super(features, config, lossFunction, featureBagger);
        this.classIdMap = classIdMap;
        assert (labels.size() == features.size());
        this.allLabels = labels;
    }

    @Override
    protected Integer toTerminal(ReadOnlyHugeLongArray group, long groupSize) {
        assert (groupSize > 0L);
        assert (group.size() >= groupSize);
        long[] classesInGroup = new long[this.classIdMap.size()];
        for (long i = 0L; i < groupSize; ++i) {
            long label = this.allLabels.get(group.get(i));
            int n = this.classIdMap.toMapped(label);
            classesInGroup[n] = classesInGroup[n] + 1L;
        }
        long maxClassCountInGroup = -1L;
        int maxMappedClass = 0;
        for (int i = 0; i < classesInGroup.length; ++i) {
            if (classesInGroup[i] <= maxClassCountInGroup) continue;
            maxClassCountInGroup = classesInGroup[i];
            maxMappedClass = i;
        }
        return maxMappedClass;
    }
}

