/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.decisiontree;

import org.neo4j.gds.decisiontree.TreeNode;

public class DecisionTreePredict<PREDICTION> {
    private final TreeNode<PREDICTION> root;

    public DecisionTreePredict(TreeNode<PREDICTION> root) {
        this.root = root;
    }

    public PREDICTION predict(double[] features) {
        assert (features.length > 0);
        TreeNode<PREDICTION> node = this.root;
        while (node.leftChild() != null) {
            assert (features.length > node.featureIndex());
            assert (node.rightChild() != null);
            if (features[node.featureIndex()] < node.thresholdValue()) {
                node = node.leftChild();
                continue;
            }
            node = node.rightChild();
        }
        return node.prediction();
    }
}

