/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.decisiontree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.decisiontree.DecisionTreeTrainConfig;

public final class DecisionTreeTrainConfigImpl
implements DecisionTreeTrainConfig {
    private int maxDepth;
    private int minSplitSize;

    public DecisionTreeTrainConfigImpl(@NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.maxDepth = config.getInt("maxDepth", DecisionTreeTrainConfig.super.maxDepth());
            CypherMapWrapper.validateIntegerRange((String)"maxDepth", (int)this.maxDepth, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.minSplitSize = config.getInt("minSplitSize", DecisionTreeTrainConfig.super.minSplitSize());
            CypherMapWrapper.validateIntegerRange((String)"minSplitSize", (int)this.minSplitSize, (int)2, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public int maxDepth() {
        return this.maxDepth;
    }

    @Override
    public int minSplitSize() {
        return this.minSplitSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public Builder maxDepth(int maxDepth) {
            this.config.put("maxDepth", maxDepth);
            return this;
        }

        public Builder minSplitSize(int minSplitSize) {
            this.config.put("minSplitSize", minSplitSize);
            return this;
        }

        public DecisionTreeTrainConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new DecisionTreeTrainConfigImpl(config);
        }
    }
}

