/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.decisiontree;

import java.util.SplittableRandom;
import org.neo4j.gds.ml.core.samplers.IntUniformSamplerFromRange;

public final class FeatureBagger {
    private final IntUniformSamplerFromRange sampler;
    private final int totalNumberOfFeatures;
    private final int numberOfSamples;

    public FeatureBagger(SplittableRandom random, int totalNumberOfFeatures, double maxFeaturesRatio) {
        assert (Double.compare(maxFeaturesRatio, 0.0) != 0) : "Invalid maxFeaturesRatio";
        this.totalNumberOfFeatures = totalNumberOfFeatures;
        this.numberOfSamples = (int)Math.ceil(maxFeaturesRatio * (double)totalNumberOfFeatures);
        this.sampler = new IntUniformSamplerFromRange(random);
    }

    public int[] sample() {
        return this.sampler.sample(0, this.totalNumberOfFeatures, this.totalNumberOfFeatures, this.numberOfSamples, i -> false);
    }
}

