/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.decisiontree;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.decisiontree.DecisionTreeTrain;
import org.neo4j.gds.decisiontree.GroupSizes;
import org.neo4j.gds.decisiontree.ReadOnlyGroups;

@Generated(from="DecisionTreeTrain.Split", generator="Immutables")
public final class ImmutableSplit
implements DecisionTreeTrain.Split {
    private final int index;
    private final double value;
    private final ReadOnlyGroups groups;
    private final GroupSizes sizes;

    private ImmutableSplit(int index, double value, ReadOnlyGroups groups, GroupSizes sizes) {
        this.index = index;
        this.value = value;
        this.groups = Objects.requireNonNull(groups, "groups");
        this.sizes = Objects.requireNonNull(sizes, "sizes");
    }

    private ImmutableSplit(ImmutableSplit original, int index, double value, ReadOnlyGroups groups, GroupSizes sizes) {
        this.index = index;
        this.value = value;
        this.groups = groups;
        this.sizes = sizes;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public double value() {
        return this.value;
    }

    @Override
    public ReadOnlyGroups groups() {
        return this.groups;
    }

    @Override
    public GroupSizes sizes() {
        return this.sizes;
    }

    public final ImmutableSplit withIndex(int value) {
        if (this.index == value) {
            return this;
        }
        return new ImmutableSplit(this, value, this.value, this.groups, this.sizes);
    }

    public final ImmutableSplit withValue(double value) {
        if (Double.doubleToLongBits(this.value) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableSplit(this, this.index, value, this.groups, this.sizes);
    }

    public final ImmutableSplit withGroups(ReadOnlyGroups value) {
        if (this.groups == value) {
            return this;
        }
        ReadOnlyGroups newValue = Objects.requireNonNull(value, "groups");
        return new ImmutableSplit(this, this.index, this.value, newValue, this.sizes);
    }

    public final ImmutableSplit withSizes(GroupSizes value) {
        if (this.sizes == value) {
            return this;
        }
        GroupSizes newValue = Objects.requireNonNull(value, "sizes");
        return new ImmutableSplit(this, this.index, this.value, this.groups, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSplit && this.equalTo((ImmutableSplit)another);
    }

    private boolean equalTo(ImmutableSplit another) {
        return this.index == another.index && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(another.value) && this.groups.equals(another.groups) && this.sizes.equals(another.sizes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.index;
        h += (h << 5) + Double.hashCode(this.value);
        h += (h << 5) + this.groups.hashCode();
        h += (h << 5) + this.sizes.hashCode();
        return h;
    }

    public String toString() {
        return "Split{index=" + this.index + ", value=" + this.value + ", groups=" + this.groups + ", sizes=" + this.sizes + "}";
    }

    public static DecisionTreeTrain.Split of(int index, double value, ReadOnlyGroups groups, GroupSizes sizes) {
        return new ImmutableSplit(index, value, groups, sizes);
    }

    static DecisionTreeTrain.Split copyOf(DecisionTreeTrain.Split instance) {
        if (instance instanceof ImmutableSplit) {
            return (ImmutableSplit)instance;
        }
        return ImmutableSplit.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DecisionTreeTrain.Split", generator="Immutables")
    static final class Builder {
        private static final long INIT_BIT_INDEX = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private static final long INIT_BIT_GROUPS = 4L;
        private static final long INIT_BIT_SIZES = 8L;
        private long initBits = 15L;
        private int index;
        private double value;
        private ReadOnlyGroups groups;
        private GroupSizes sizes;

        private Builder() {
        }

        public final Builder from(ImmutableSplit instance) {
            return this.from((DecisionTreeTrain.Split)instance);
        }

        final Builder from(DecisionTreeTrain.Split instance) {
            Objects.requireNonNull(instance, "instance");
            this.index(instance.index());
            this.value(instance.value());
            this.groups(instance.groups());
            this.sizes(instance.sizes());
            return this;
        }

        public final Builder index(int index) {
            this.index = index;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder value(double value) {
            this.value = value;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder groups(ReadOnlyGroups groups) {
            this.groups = Objects.requireNonNull(groups, "groups");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder sizes(GroupSizes sizes) {
            this.sizes = Objects.requireNonNull(sizes, "sizes");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Builder clear() {
            this.initBits = 15L;
            this.index = 0;
            this.value = 0.0;
            this.groups = null;
            this.sizes = null;
            return this;
        }

        public DecisionTreeTrain.Split build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSplit(null, this.index, this.value, this.groups, this.sizes);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("index");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("groups");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("sizes");
            }
            return "Cannot build Split, some of required attributes are not set " + attributes;
        }
    }
}

