/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.decisiontree;

import org.neo4j.gds.utils.StringFormatting;

public class TreeNode<PREDICTION> {
    private PREDICTION prediction;
    private int featureIndex = -1;
    private double thresholdValue;
    private TreeNode<PREDICTION> leftChild = null;
    private TreeNode<PREDICTION> rightChild = null;

    public TreeNode(int index, double value) {
        assert (index >= 0);
        this.featureIndex = index;
        this.thresholdValue = value;
    }

    public TreeNode(PREDICTION prediction) {
        this.prediction = prediction;
    }

    PREDICTION prediction() {
        return this.prediction;
    }

    int featureIndex() {
        return this.featureIndex;
    }

    double thresholdValue() {
        return this.thresholdValue;
    }

    TreeNode<PREDICTION> leftChild() {
        return this.leftChild;
    }

    void setLeftChild(TreeNode leftChild) {
        this.leftChild = leftChild;
    }

    TreeNode<PREDICTION> rightChild() {
        return this.rightChild;
    }

    void setRightChild(TreeNode rightChild) {
        this.rightChild = rightChild;
    }

    public String toString() {
        return StringFormatting.formatWithLocale((String)"Node: prediction %s, featureIndex %s, splitValue %f", (Object[])new Object[]{this.prediction, this.featureIndex, this.thresholdValue});
    }

    public String render() {
        StringBuilder sb = new StringBuilder();
        TreeNode.render(sb, this, 0);
        return sb.toString();
    }

    static void render(StringBuilder sb, TreeNode<?> node, int depth) {
        if (node == null) {
            return;
        }
        sb.append("\t".repeat(Math.max(0, depth - 1)));
        if (depth > 0) {
            sb.append("|-- ");
        }
        sb.append(node);
        sb.append(System.lineSeparator());
        TreeNode.render(sb, node.leftChild, depth + 1);
        TreeNode.render(sb, node.rightChild, depth + 1);
    }
}

