/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.models;

import org.neo4j.gds.models.Classifier;
import org.neo4j.gds.models.logisticregression.LogisticRegressionClassifier;
import org.neo4j.gds.models.logisticregression.LogisticRegressionData;
import org.neo4j.gds.models.randomforest.ClassificationRandomForestPredictor;
import org.neo4j.gds.models.randomforest.RandomForestData;

public final class ClassifierFactory {
    private ClassifierFactory() {
    }

    public static Classifier create(Classifier.ClassifierData classifierData) {
        switch (classifierData.trainerMethod()) {
            case LogisticRegression: {
                return LogisticRegressionClassifier.from((LogisticRegressionData)classifierData);
            }
            case RandomForest: {
                return new ClassificationRandomForestPredictor((RandomForestData)classifierData);
            }
        }
        throw new IllegalStateException("No such classifier.");
    }
}

