/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.models;

import java.util.Collection;
import java.util.List;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.ml.core.features.FeatureConsumer;
import org.neo4j.gds.ml.core.features.FeatureExtraction;
import org.neo4j.gds.models.Features;

public final class FeaturesFactory {
    private FeaturesFactory() {
    }

    public static Features extractLazyFeatures(final Graph graph, List<String> featureProperties) {
        final List featureExtractors = FeatureExtraction.propertyExtractors((Graph)graph, featureProperties);
        final int numberOfFeatures = FeatureExtraction.featureCount((Collection)featureExtractors);
        Features features = new Features(){

            @Override
            public long size() {
                return graph.nodeCount();
            }

            @Override
            public double[] get(long id) {
                final double[] features = new double[numberOfFeatures];
                FeatureExtraction.extract((long)id, (long)0L, (List)featureExtractors, (FeatureConsumer)new FeatureConsumer(){

                    public void acceptScalar(long nodeOffset, int offset, double value) {
                        features[offset] = value;
                    }

                    public void acceptArray(long nodeOffset, int offset, double[] values) {
                        System.arraycopy(values, 0, features, offset, values.length);
                    }
                });
                return features;
            }

            @Override
            public int featureDimension() {
                return numberOfFeatures;
            }
        };
        return features;
    }

    public static Features extractEagerFeatures(Graph graph, List<String> featureProperties) {
        List featureExtractors = FeatureExtraction.propertyExtractors((Graph)graph, featureProperties);
        HugeObjectArray featuresArray = HugeObjectArray.newArray(double[].class, (long)graph.nodeCount());
        FeatureExtraction.extract((Graph)graph, (List)featureExtractors, (HugeObjectArray)featuresArray);
        return FeaturesFactory.wrap((HugeObjectArray<double[]>)featuresArray);
    }

    public static Features wrap(final HugeObjectArray<double[]> features) {
        return new Features(){

            @Override
            public long size() {
                return features.size();
            }

            @Override
            public double[] get(long id) {
                return (double[])features.get(id);
            }
        };
    }

    public static Features wrap(final double[] features) {
        return new Features(){

            @Override
            public long size() {
                return 1L;
            }

            @Override
            public double[] get(long id) {
                assert (id == 0L);
                return features;
            }
        };
    }

    public static Features wrap(final List<double[]> features) {
        return new Features(){

            @Override
            public long size() {
                return features.size();
            }

            @Override
            public double[] get(long id) {
                return (double[])features.get(Math.toIntExact(id));
            }
        };
    }
}

