/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.models;

import java.util.Optional;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.ml.core.subgraph.LocalIdMap;
import org.neo4j.gds.models.Trainer;
import org.neo4j.gds.models.TrainerConfig;
import org.neo4j.gds.models.TrainingMethod;
import org.neo4j.gds.models.logisticregression.LogisticRegressionTrainConfig;
import org.neo4j.gds.models.logisticregression.LogisticRegressionTrainer;
import org.neo4j.gds.models.randomforest.ClassificationRandomForestTrainer;
import org.neo4j.gds.models.randomforest.RandomForestTrainConfig;

public class TrainerFactory {
    private TrainerFactory() {
    }

    public static Trainer create(TrainerConfig config, LocalIdMap classIdMap, TerminationFlag terminationFlag, ProgressTracker progressTracker, int concurrency, Optional<Long> randomSeed, boolean reduceClassCount) {
        switch (TrainingMethod.valueOf(config.methodName())) {
            case LogisticRegression: {
                return new LogisticRegressionTrainer(concurrency, (LogisticRegressionTrainConfig)config, classIdMap, reduceClassCount, terminationFlag, progressTracker);
            }
            case RandomForest: {
                return new ClassificationRandomForestTrainer(concurrency, classIdMap, (RandomForestTrainConfig)config, false, randomSeed, progressTracker);
            }
        }
        throw new IllegalStateException("No such training method.");
    }
}

