/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.models.logisticregression;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.core.functions.Weights;
import org.neo4j.gds.ml.core.subgraph.LocalIdMap;
import org.neo4j.gds.ml.core.tensor.Matrix;
import org.neo4j.gds.ml.core.tensor.Vector;
import org.neo4j.gds.models.Classifier;
import org.neo4j.gds.models.TrainingMethod;
import org.neo4j.gds.models.logisticregression.LogisticRegressionData;

@Generated(from="LogisticRegressionData", generator="Immutables")
public final class ImmutableLogisticRegressionData
implements LogisticRegressionData {
    private final LocalIdMap classIdMap;
    private final Weights<Matrix> weights;
    private final Weights<Vector> bias;
    private final transient TrainingMethod trainerMethod;
    private final transient int featureDimension;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableLogisticRegressionData(LocalIdMap classIdMap, Weights<Matrix> weights, Weights<Vector> bias) {
        this.classIdMap = Objects.requireNonNull(classIdMap, "classIdMap");
        this.weights = Objects.requireNonNull(weights, "weights");
        this.bias = Objects.requireNonNull(bias, "bias");
        this.trainerMethod = this.initShim.trainerMethod();
        this.featureDimension = this.initShim.featureDimension();
        this.initShim = null;
    }

    private ImmutableLogisticRegressionData(ImmutableLogisticRegressionData original, LocalIdMap classIdMap, Weights<Matrix> weights, Weights<Vector> bias) {
        this.classIdMap = classIdMap;
        this.weights = weights;
        this.bias = bias;
        this.trainerMethod = this.initShim.trainerMethod();
        this.featureDimension = this.initShim.featureDimension();
        this.initShim = null;
    }

    private TrainingMethod trainerMethodInitialize() {
        return LogisticRegressionData.super.trainerMethod();
    }

    private int featureDimensionInitialize() {
        return LogisticRegressionData.super.featureDimension();
    }

    @Override
    public LocalIdMap classIdMap() {
        return this.classIdMap;
    }

    @Override
    public Weights<Matrix> weights() {
        return this.weights;
    }

    @Override
    public Weights<Vector> bias() {
        return this.bias;
    }

    @Override
    public TrainingMethod trainerMethod() {
        InitShim shim = this.initShim;
        return shim != null ? shim.trainerMethod() : this.trainerMethod;
    }

    @Override
    public int featureDimension() {
        InitShim shim = this.initShim;
        return shim != null ? shim.featureDimension() : this.featureDimension;
    }

    public final ImmutableLogisticRegressionData withClassIdMap(LocalIdMap value) {
        if (this.classIdMap == value) {
            return this;
        }
        LocalIdMap newValue = Objects.requireNonNull(value, "classIdMap");
        return new ImmutableLogisticRegressionData(this, newValue, this.weights, this.bias);
    }

    public final ImmutableLogisticRegressionData withWeights(Weights<Matrix> value) {
        if (this.weights == value) {
            return this;
        }
        Weights<Matrix> newValue = Objects.requireNonNull(value, "weights");
        return new ImmutableLogisticRegressionData(this, this.classIdMap, newValue, this.bias);
    }

    public final ImmutableLogisticRegressionData withBias(Weights<Vector> value) {
        if (this.bias == value) {
            return this;
        }
        Weights<Vector> newValue = Objects.requireNonNull(value, "bias");
        return new ImmutableLogisticRegressionData(this, this.classIdMap, this.weights, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLogisticRegressionData && this.equalTo((ImmutableLogisticRegressionData)another);
    }

    private boolean equalTo(ImmutableLogisticRegressionData another) {
        return this.classIdMap.equals((Object)another.classIdMap) && this.weights.equals(another.weights) && this.bias.equals(another.bias) && this.trainerMethod.equals((Object)another.trainerMethod) && this.featureDimension == another.featureDimension;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.classIdMap.hashCode();
        h += (h << 5) + this.weights.hashCode();
        h += (h << 5) + this.bias.hashCode();
        h += (h << 5) + this.trainerMethod.hashCode();
        h += (h << 5) + this.featureDimension;
        return h;
    }

    public String toString() {
        return "LogisticRegressionData{classIdMap=" + this.classIdMap + ", weights=" + this.weights + ", bias=" + this.bias + ", trainerMethod=" + this.trainerMethod + ", featureDimension=" + this.featureDimension + "}";
    }

    public static LogisticRegressionData of(LocalIdMap classIdMap, Weights<Matrix> weights, Weights<Vector> bias) {
        return new ImmutableLogisticRegressionData(classIdMap, weights, bias);
    }

    public static LogisticRegressionData copyOf(LogisticRegressionData instance) {
        if (instance instanceof ImmutableLogisticRegressionData) {
            return (ImmutableLogisticRegressionData)instance;
        }
        return ImmutableLogisticRegressionData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LogisticRegressionData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CLASS_ID_MAP = 1L;
        private static final long INIT_BIT_WEIGHTS = 2L;
        private static final long INIT_BIT_BIAS = 4L;
        private long initBits = 7L;
        private LocalIdMap classIdMap;
        private Weights<Matrix> weights;
        private Weights<Vector> bias;

        private Builder() {
        }

        public final Builder from(Classifier.ClassifierData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(LogisticRegressionData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Classifier.ClassifierData instance;
            if (object instanceof Classifier.ClassifierData) {
                instance = (Classifier.ClassifierData)object;
                this.classIdMap(instance.classIdMap());
            }
            if (object instanceof LogisticRegressionData) {
                instance = (LogisticRegressionData)object;
                this.weights(instance.weights());
                this.bias(instance.bias());
            }
        }

        public final Builder classIdMap(LocalIdMap classIdMap) {
            this.classIdMap = Objects.requireNonNull(classIdMap, "classIdMap");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder weights(Weights<Matrix> weights) {
            this.weights = Objects.requireNonNull(weights, "weights");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder bias(Weights<Vector> bias) {
            this.bias = Objects.requireNonNull(bias, "bias");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.classIdMap = null;
            this.weights = null;
            this.bias = null;
            return this;
        }

        public LogisticRegressionData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLogisticRegressionData(null, this.classIdMap, this.weights, this.bias);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("classIdMap");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("weights");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("bias");
            }
            return "Cannot build LogisticRegressionData, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="LogisticRegressionData", generator="Immutables")
    private final class InitShim {
        private byte trainerMethodBuildStage = 0;
        private TrainingMethod trainerMethod;
        private byte featureDimensionBuildStage = 0;
        private int featureDimension;

        private InitShim() {
        }

        TrainingMethod trainerMethod() {
            if (this.trainerMethodBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.trainerMethodBuildStage == 0) {
                this.trainerMethodBuildStage = (byte)-1;
                this.trainerMethod = Objects.requireNonNull(ImmutableLogisticRegressionData.this.trainerMethodInitialize(), "trainerMethod");
                this.trainerMethodBuildStage = 1;
            }
            return this.trainerMethod;
        }

        int featureDimension() {
            if (this.featureDimensionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.featureDimensionBuildStage == 0) {
                this.featureDimensionBuildStage = (byte)-1;
                this.featureDimension = ImmutableLogisticRegressionData.this.featureDimensionInitialize();
                this.featureDimensionBuildStage = 1;
            }
            return this.featureDimension;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.trainerMethodBuildStage == -1) {
                attributes.add("trainerMethod");
            }
            if (this.featureDimensionBuildStage == -1) {
                attributes.add("featureDimension");
            }
            return "Cannot build LogisticRegressionData, attribute initializers form cycle " + attributes;
        }
    }
}

