/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.models.logisticregression;

import java.util.Collection;
import java.util.Map;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.gradientdescent.GradientDescentConfig;
import org.neo4j.gds.models.TrainerConfig;
import org.neo4j.gds.models.TrainingMethod;
import org.neo4j.gds.models.logisticregression.LogisticRegressionTrainConfigImpl;

@Configuration
public interface LogisticRegressionTrainConfig
extends GradientDescentConfig,
TrainerConfig {
    @Value.Default
    @Configuration.DoubleRange(min=0.0)
    default public double penalty() {
        return 0.0;
    }

    @Configuration.ToMap
    public Map<String, Object> toMap();

    @Configuration.CollectKeys
    public Collection<String> configKeys();

    public static LogisticRegressionTrainConfig of(Map<String, Object> params) {
        CypherMapWrapper cypherMapWrapper = CypherMapWrapper.create(params);
        LogisticRegressionTrainConfigImpl config = new LogisticRegressionTrainConfigImpl(cypherMapWrapper);
        cypherMapWrapper.requireOnlyKeysFrom(config.configKeys());
        return config;
    }

    @Override
    @Configuration.Ignore
    default public String methodName() {
        return TrainingMethod.LogisticRegression.name();
    }

    public static LogisticRegressionTrainConfig defaultConfig() {
        return LogisticRegressionTrainConfig.of(Map.of());
    }
}

