/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.models.logisticregression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.models.logisticregression.LogisticRegressionTrainConfig;

public final class LogisticRegressionTrainConfigImpl
implements LogisticRegressionTrainConfig {
    private double penalty;
    private int batchSize;
    private int minEpochs;
    private int patience;
    private int maxEpochs;
    private double tolerance;

    public LogisticRegressionTrainConfigImpl(@NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.penalty = config.getDouble("penalty", LogisticRegressionTrainConfig.super.penalty());
            CypherMapWrapper.validateDoubleRange((String)"penalty", (double)this.penalty, (double)0.0, (double)Double.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.batchSize = config.getInt("batchSize", LogisticRegressionTrainConfig.super.batchSize());
            CypherMapWrapper.validateIntegerRange((String)"batchSize", (int)this.batchSize, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.minEpochs = config.getInt("minEpochs", LogisticRegressionTrainConfig.super.minEpochs());
            CypherMapWrapper.validateIntegerRange((String)"minEpochs", (int)this.minEpochs, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.patience = config.getInt("patience", LogisticRegressionTrainConfig.super.patience());
            CypherMapWrapper.validateIntegerRange((String)"patience", (int)this.patience, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.maxEpochs = config.getInt("maxEpochs", LogisticRegressionTrainConfig.super.maxEpochs());
            CypherMapWrapper.validateIntegerRange((String)"maxEpochs", (int)this.maxEpochs, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.tolerance = config.getDouble("tolerance", LogisticRegressionTrainConfig.super.tolerance());
            CypherMapWrapper.validateDoubleRange((String)"tolerance", (double)this.tolerance, (double)0.0, (double)Double.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public double penalty() {
        return this.penalty;
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("penalty", this.penalty());
        map.put("batchSize", this.batchSize());
        map.put("minEpochs", this.minEpochs());
        map.put("patience", this.patience());
        map.put("maxEpochs", this.maxEpochs());
        map.put("tolerance", this.tolerance());
        return map;
    }

    @Override
    public Collection<String> configKeys() {
        return Arrays.asList("penalty", "batchSize", "minEpochs", "patience", "maxEpochs", "tolerance");
    }

    @Override
    public int batchSize() {
        return this.batchSize;
    }

    @Override
    public int minEpochs() {
        return this.minEpochs;
    }

    @Override
    public int patience() {
        return this.patience;
    }

    @Override
    public int maxEpochs() {
        return this.maxEpochs;
    }

    @Override
    public double tolerance() {
        return this.tolerance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public Builder penalty(double penalty) {
            this.config.put("penalty", penalty);
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.config.put("batchSize", batchSize);
            return this;
        }

        public Builder minEpochs(int minEpochs) {
            this.config.put("minEpochs", minEpochs);
            return this;
        }

        public Builder patience(int patience) {
            this.config.put("patience", patience);
            return this;
        }

        public Builder maxEpochs(int maxEpochs) {
            this.config.put("maxEpochs", maxEpochs);
            return this;
        }

        public Builder tolerance(double tolerance) {
            this.config.put("tolerance", tolerance);
            return this;
        }

        public LogisticRegressionTrainConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new LogisticRegressionTrainConfigImpl(config);
        }
    }
}

