/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.models.randomforest;

import java.util.Iterator;
import java.util.List;
import org.neo4j.gds.decisiontree.DecisionTreePredict;
import org.neo4j.gds.ml.core.batch.Batch;
import org.neo4j.gds.ml.core.subgraph.LocalIdMap;
import org.neo4j.gds.ml.core.tensor.Matrix;
import org.neo4j.gds.models.Classifier;
import org.neo4j.gds.models.Features;
import org.neo4j.gds.models.randomforest.ImmutableRandomForestData;
import org.neo4j.gds.models.randomforest.RandomForestData;

public class ClassificationRandomForestPredictor
implements Classifier {
    private final RandomForestData data;

    public ClassificationRandomForestPredictor(List<DecisionTreePredict<Integer>> decisionTrees, LocalIdMap classMapping, int featureDimension) {
        this(ImmutableRandomForestData.of(classMapping, featureDimension, decisionTrees));
    }

    public ClassificationRandomForestPredictor(RandomForestData data) {
        this.data = data;
    }

    @Override
    public LocalIdMap classIdMap() {
        return this.data.classIdMap();
    }

    @Override
    public Classifier.ClassifierData data() {
        return this.data;
    }

    @Override
    public double[] predictProbabilities(long id, Features features) {
        return this.predictProbabilities(features.get(id));
    }

    @Override
    public Matrix predictProbabilities(Batch batch, Features features) {
        Matrix predictedProbabilities = new Matrix(batch.size(), this.numberOfClasses());
        int offset = 0;
        Iterator iterator = batch.nodeIds().iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            predictedProbabilities.setRow(offset++, this.predictProbabilities(id, features));
        }
        return predictedProbabilities;
    }

    public double[] predictProbabilities(double[] features) {
        int[] votesPerClass = this.gatherTreePredictions(features);
        int numberOfTrees = this.data.decisionTrees().size();
        double[] probabilities = new double[this.data.classIdMap().size()];
        for (int classIdx = 0; classIdx < votesPerClass.length; ++classIdx) {
            int voteForClass = votesPerClass[classIdx];
            probabilities[classIdx] = (double)voteForClass / (double)numberOfTrees;
        }
        return probabilities;
    }

    int[] gatherTreePredictions(double[] features) {
        LocalIdMap classMapping = this.data.classIdMap();
        int[] predictionsPerClass = new int[classMapping.size()];
        for (DecisionTreePredict<Integer> decisionTree : this.data.decisionTrees()) {
            int predictedClass;
            int n = predictedClass = decisionTree.predict(features).intValue();
            predictionsPerClass[n] = predictionsPerClass[n] + 1;
        }
        return predictionsPerClass;
    }
}

