/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.models.randomforest;

import com.carrotsearch.hppc.BitSet;
import java.util.SplittableRandom;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.ReadOnlyHugeLongArray;

final class DatasetBootstrapper {
    private DatasetBootstrapper() {
    }

    static ReadOnlyHugeLongArray bootstrap(SplittableRandom random, double numFeatureVectorsRatio, ReadOnlyHugeLongArray trainSet, BitSet bootstrappedTrainSetIndices) {
        assert (numFeatureVectorsRatio >= 0.0 && numFeatureVectorsRatio <= 1.0);
        long numVectors = (long)Math.ceil(numFeatureVectorsRatio * (double)trainSet.size());
        HugeLongArray bootstrappedVectors = HugeLongArray.newArray((long)numVectors);
        for (long i = 0L; i < numVectors; ++i) {
            long sampledTrainingIdx = random.nextLong(0L, trainSet.size());
            bootstrappedVectors.set(i, trainSet.get(sampledTrainingIdx));
            bootstrappedTrainSetIndices.set(sampledTrainingIdx);
        }
        return ReadOnlyHugeLongArray.of((HugeLongArray)bootstrappedVectors);
    }
}

