/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.models.randomforest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.decisiontree.DecisionTreePredict;
import org.neo4j.gds.ml.core.subgraph.LocalIdMap;
import org.neo4j.gds.models.Classifier;
import org.neo4j.gds.models.TrainingMethod;
import org.neo4j.gds.models.randomforest.RandomForestData;

@Generated(from="RandomForestData", generator="Immutables")
public final class ImmutableRandomForestData
implements RandomForestData {
    private final LocalIdMap classIdMap;
    private final int featureDimension;
    private final List<DecisionTreePredict<Integer>> decisionTrees;
    private final transient TrainingMethod trainerMethod;

    private ImmutableRandomForestData(LocalIdMap classIdMap, int featureDimension, Iterable<? extends DecisionTreePredict<Integer>> decisionTrees) {
        this.classIdMap = Objects.requireNonNull(classIdMap, "classIdMap");
        this.featureDimension = featureDimension;
        this.decisionTrees = ImmutableRandomForestData.createUnmodifiableList(false, ImmutableRandomForestData.createSafeList(decisionTrees, true, false));
        this.trainerMethod = Objects.requireNonNull(RandomForestData.super.trainerMethod(), "trainerMethod");
    }

    private ImmutableRandomForestData(ImmutableRandomForestData original, LocalIdMap classIdMap, int featureDimension, List<DecisionTreePredict<Integer>> decisionTrees) {
        this.classIdMap = classIdMap;
        this.featureDimension = featureDimension;
        this.decisionTrees = decisionTrees;
        this.trainerMethod = Objects.requireNonNull(RandomForestData.super.trainerMethod(), "trainerMethod");
    }

    @Override
    public LocalIdMap classIdMap() {
        return this.classIdMap;
    }

    @Override
    public int featureDimension() {
        return this.featureDimension;
    }

    @Override
    public List<DecisionTreePredict<Integer>> decisionTrees() {
        return this.decisionTrees;
    }

    @Override
    public TrainingMethod trainerMethod() {
        return this.trainerMethod;
    }

    public final ImmutableRandomForestData withClassIdMap(LocalIdMap value) {
        if (this.classIdMap == value) {
            return this;
        }
        LocalIdMap newValue = Objects.requireNonNull(value, "classIdMap");
        return new ImmutableRandomForestData(this, newValue, this.featureDimension, this.decisionTrees);
    }

    public final ImmutableRandomForestData withFeatureDimension(int value) {
        if (this.featureDimension == value) {
            return this;
        }
        return new ImmutableRandomForestData(this, this.classIdMap, value, this.decisionTrees);
    }

    @SafeVarargs
    public final ImmutableRandomForestData withDecisionTrees(DecisionTreePredict<Integer> ... elements) {
        List<DecisionTreePredict<Integer>> newValue = ImmutableRandomForestData.createUnmodifiableList(false, ImmutableRandomForestData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableRandomForestData(this, this.classIdMap, this.featureDimension, newValue);
    }

    public final ImmutableRandomForestData withDecisionTrees(Iterable<? extends DecisionTreePredict<Integer>> elements) {
        if (this.decisionTrees == elements) {
            return this;
        }
        List<DecisionTreePredict<Integer>> newValue = ImmutableRandomForestData.createUnmodifiableList(false, ImmutableRandomForestData.createSafeList(elements, true, false));
        return new ImmutableRandomForestData(this, this.classIdMap, this.featureDimension, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRandomForestData && this.equalTo((ImmutableRandomForestData)another);
    }

    private boolean equalTo(ImmutableRandomForestData another) {
        return this.classIdMap.equals((Object)another.classIdMap) && this.featureDimension == another.featureDimension && this.decisionTrees.equals(another.decisionTrees) && this.trainerMethod.equals((Object)another.trainerMethod);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.classIdMap.hashCode();
        h += (h << 5) + this.featureDimension;
        h += (h << 5) + this.decisionTrees.hashCode();
        h += (h << 5) + this.trainerMethod.hashCode();
        return h;
    }

    public String toString() {
        return "RandomForestData{classIdMap=" + this.classIdMap + ", featureDimension=" + this.featureDimension + ", decisionTrees=" + this.decisionTrees + ", trainerMethod=" + this.trainerMethod + "}";
    }

    public static RandomForestData of(LocalIdMap classIdMap, int featureDimension, List<DecisionTreePredict<Integer>> decisionTrees) {
        return ImmutableRandomForestData.of(classIdMap, featureDimension, decisionTrees);
    }

    public static RandomForestData of(LocalIdMap classIdMap, int featureDimension, Iterable<? extends DecisionTreePredict<Integer>> decisionTrees) {
        return new ImmutableRandomForestData(classIdMap, featureDimension, decisionTrees);
    }

    public static RandomForestData copyOf(RandomForestData instance) {
        if (instance instanceof ImmutableRandomForestData) {
            return (ImmutableRandomForestData)instance;
        }
        return ImmutableRandomForestData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="RandomForestData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CLASS_ID_MAP = 1L;
        private static final long INIT_BIT_FEATURE_DIMENSION = 2L;
        private long initBits = 3L;
        private LocalIdMap classIdMap;
        private int featureDimension;
        private List<DecisionTreePredict<Integer>> decisionTrees = null;

        private Builder() {
        }

        public final Builder from(Classifier.ClassifierData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomForestData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Classifier.ClassifierData instance;
            if (object instanceof Classifier.ClassifierData) {
                instance = (Classifier.ClassifierData)object;
                this.classIdMap(instance.classIdMap());
                this.featureDimension(instance.featureDimension());
            }
            if (object instanceof RandomForestData) {
                instance = (RandomForestData)object;
                this.addAllDecisionTrees(instance.decisionTrees());
            }
        }

        public final Builder classIdMap(LocalIdMap classIdMap) {
            this.classIdMap = Objects.requireNonNull(classIdMap, "classIdMap");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder featureDimension(int featureDimension) {
            this.featureDimension = featureDimension;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addDecisionTree(DecisionTreePredict<Integer> element) {
            if (this.decisionTrees == null) {
                this.decisionTrees = new ArrayList<DecisionTreePredict<Integer>>();
            }
            this.decisionTrees.add(Objects.requireNonNull(element, "decisionTrees element"));
            return this;
        }

        @SafeVarargs
        public final Builder addDecisionTrees(DecisionTreePredict<Integer> ... elements) {
            if (this.decisionTrees == null) {
                this.decisionTrees = new ArrayList<DecisionTreePredict<Integer>>();
            }
            for (DecisionTreePredict<Integer> element : elements) {
                this.decisionTrees.add(Objects.requireNonNull(element, "decisionTrees element"));
            }
            return this;
        }

        public final Builder decisionTrees(Iterable<? extends DecisionTreePredict<Integer>> elements) {
            this.decisionTrees = new ArrayList<DecisionTreePredict<Integer>>();
            return this.addAllDecisionTrees(elements);
        }

        public final Builder addAllDecisionTrees(Iterable<? extends DecisionTreePredict<Integer>> elements) {
            Objects.requireNonNull(elements, "decisionTrees element");
            if (this.decisionTrees == null) {
                this.decisionTrees = new ArrayList<DecisionTreePredict<Integer>>();
            }
            for (DecisionTreePredict<Integer> decisionTreePredict : elements) {
                this.decisionTrees.add(Objects.requireNonNull(decisionTreePredict, "decisionTrees element"));
            }
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.classIdMap = null;
            this.featureDimension = 0;
            if (this.decisionTrees != null) {
                this.decisionTrees.clear();
            }
            return this;
        }

        public RandomForestData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRandomForestData(null, this.classIdMap, this.featureDimension, this.decisionTrees == null ? Collections.emptyList() : ImmutableRandomForestData.createUnmodifiableList(true, this.decisionTrees));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("classIdMap");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("featureDimension");
            }
            return "Cannot build RandomForestData, some of required attributes are not set " + attributes;
        }
    }
}

