/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.models.randomforest;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.decisiontree.DecisionTreeTrainConfig;
import org.neo4j.gds.models.TrainerConfig;
import org.neo4j.gds.models.TrainingMethod;
import org.neo4j.gds.models.randomforest.RandomForestTrainConfigImpl;

@Configuration
public interface RandomForestTrainConfig
extends DecisionTreeTrainConfig,
TrainerConfig {
    @Configuration.DoubleRange(min=0.0, max=1.0, minInclusive=false)
    public Optional<Double> maxFeaturesRatio();

    @Configuration.Ignore
    default public double maxFeaturesRatio(int featureDimension) {
        return this.maxFeaturesRatio().orElse(1.0 / Math.sqrt(featureDimension));
    }

    @Configuration.DoubleRange(min=0.0, max=1.0)
    default public double numberOfSamplesRatio() {
        return 1.0;
    }

    @Configuration.IntegerRange(min=1)
    default public int numberOfDecisionTrees() {
        return 100;
    }

    @Override
    @Configuration.Ignore
    default public String methodName() {
        return TrainingMethod.RandomForest.name();
    }

    public static RandomForestTrainConfig of(Map<String, Object> params) {
        CypherMapWrapper cypherMapWrapper = CypherMapWrapper.create(params);
        RandomForestTrainConfigImpl config = new RandomForestTrainConfigImpl(cypherMapWrapper);
        cypherMapWrapper.requireOnlyKeysFrom(config.configKeys());
        return config;
    }

    @Configuration.CollectKeys
    public Collection<String> configKeys();

    @Configuration.ToMap
    public Map<String, Object> toMap();
}

