/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.models.randomforest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.models.randomforest.RandomForestTrainConfig;

public final class RandomForestTrainConfigImpl
implements RandomForestTrainConfig {
    private Optional<Double> maxFeaturesRatio;
    private double numberOfSamplesRatio;
    private int numberOfDecisionTrees;
    private int maxDepth;
    private int minSplitSize;

    public RandomForestTrainConfigImpl(@NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.maxFeaturesRatio = (Optional)CypherMapWrapper.failOnNull((String)"maxFeaturesRatio", (Object)config.getOptional("maxFeaturesRatio", Double.class));
            this.maxFeaturesRatio.ifPresent(maxFeaturesRatio -> CypherMapWrapper.validateDoubleRange((String)"maxFeaturesRatio", (double)maxFeaturesRatio, (double)0.0, (double)1.0, (boolean)false, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.numberOfSamplesRatio = config.getDouble("numberOfSamplesRatio", RandomForestTrainConfig.super.numberOfSamplesRatio());
            CypherMapWrapper.validateDoubleRange((String)"numberOfSamplesRatio", (double)this.numberOfSamplesRatio, (double)0.0, (double)1.0, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.numberOfDecisionTrees = config.getInt("numberOfDecisionTrees", RandomForestTrainConfig.super.numberOfDecisionTrees());
            CypherMapWrapper.validateIntegerRange((String)"numberOfDecisionTrees", (int)this.numberOfDecisionTrees, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.maxDepth = config.getInt("maxDepth", RandomForestTrainConfig.super.maxDepth());
            CypherMapWrapper.validateIntegerRange((String)"maxDepth", (int)this.maxDepth, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.minSplitSize = config.getInt("minSplitSize", RandomForestTrainConfig.super.minSplitSize());
            CypherMapWrapper.validateIntegerRange((String)"minSplitSize", (int)this.minSplitSize, (int)2, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public Optional<Double> maxFeaturesRatio() {
        return this.maxFeaturesRatio;
    }

    @Override
    public double numberOfSamplesRatio() {
        return this.numberOfSamplesRatio;
    }

    @Override
    public int numberOfDecisionTrees() {
        return this.numberOfDecisionTrees;
    }

    @Override
    public Collection<String> configKeys() {
        return Arrays.asList("maxFeaturesRatio", "numberOfSamplesRatio", "numberOfDecisionTrees", "maxDepth", "minSplitSize");
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.maxFeaturesRatio().ifPresent(maxFeaturesRatio -> map.put("maxFeaturesRatio", maxFeaturesRatio));
        map.put("numberOfSamplesRatio", this.numberOfSamplesRatio());
        map.put("numberOfDecisionTrees", this.numberOfDecisionTrees());
        map.put("maxDepth", this.maxDepth());
        map.put("minSplitSize", this.minSplitSize());
        return map;
    }

    @Override
    public int maxDepth() {
        return this.maxDepth;
    }

    @Override
    public int minSplitSize() {
        return this.minSplitSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public Builder maxFeaturesRatio(Double maxFeaturesRatio) {
            this.config.put("maxFeaturesRatio", maxFeaturesRatio);
            return this;
        }

        public Builder maxFeaturesRatio(Optional<Double> maxFeaturesRatio) {
            maxFeaturesRatio.ifPresent(actualmaxFeaturesRatio -> this.config.put("maxFeaturesRatio", actualmaxFeaturesRatio));
            return this;
        }

        public Builder numberOfSamplesRatio(double numberOfSamplesRatio) {
            this.config.put("numberOfSamplesRatio", numberOfSamplesRatio);
            return this;
        }

        public Builder numberOfDecisionTrees(int numberOfDecisionTrees) {
            this.config.put("numberOfDecisionTrees", numberOfDecisionTrees);
            return this;
        }

        public Builder maxDepth(int maxDepth) {
            this.config.put("maxDepth", maxDepth);
            return this;
        }

        public Builder minSplitSize(int minSplitSize) {
            this.config.put("minSplitSize", minSplitSize);
            return this;
        }

        public RandomForestTrainConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new RandomForestTrainConfigImpl(config);
        }
    }
}

