/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.core.features;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.extension.GdlExtension;
import org.neo4j.gds.extension.GdlGraph;
import org.neo4j.gds.extension.Inject;

@GdlExtension
public abstract class FeatureExtractionBaseTest {
    @GdlGraph(graphNamePrefix="valid")
    private static final String VALID = "CREATE   (n1:N {a: [2.0, 1.0], b: 1.2}), (n2:N {a: [1.3, 1.0], b: 0.5}), (n3:N {a: [0.0, 1.0], b: 2.8}), (n4:N {a: [1.0, 1.0], b: 0.9})";
    @GdlGraph(graphNamePrefix="missingArray")
    private static final String MISSING_ARRAY = "CREATE   (n1:N {b: 1.2}), (n2:N {a: [1.3, 1.0], b: 0.5}), (n3:N {a: [0.0, 1.0], b: 2.8}), (n4:N {a: [1.0, 1.0], b: 0.9})";
    @GdlGraph(graphNamePrefix="missingArray2")
    private static final String MISSING_ARRAY2 = "CREATE   (n1:N {a: [1.3, 1.0], b: 1.2}), (n2:N {b: 0.5}), (n3:N {a: [0.0, 1.0], b: 2.8}), (n4:N {a: [1.0, 1.0], b: 0.9})";
    @GdlGraph(graphNamePrefix="missingScalar")
    private static final String MISSING_SCALAR = "CREATE   (n1:N {a: [2.0, 1.0]}), (n2:N {a: [1.3, 1.0], b: 0.5}), (n3:N {a: [0.0, 1.0], b: 2.8}), (n4:N {a: [1.0, 1.0], b: 0.9})";
    @GdlGraph(graphNamePrefix="invalid")
    private static final String INVALID = "CREATE   (n1:N {a: [2.0, 1.0], b: 1.2}), (n2:N {a: [1.3], b: 0.5}), (n3:N {a: [0.0, 1.0], b: 2.8}), (n4:N {a: [1.0, 1.0], b: 0.9})";
    @Inject
    protected Graph validGraph;
    @Inject
    protected Graph missingArrayGraph;
    @Inject
    protected Graph missingArray2Graph;
    @Inject
    protected Graph missingScalarGraph;
    @Inject
    protected Graph invalidGraph;

    public abstract void makeExtractions(Graph var1);

    @Test
    void shouldFailOnMissingScalarProperty() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> this.makeExtractions(this.missingScalarGraph)).withMessageContaining("Node with ID `0` has invalid feature property value `NaN` for property `b`");
    }

    @Test
    void shouldFailOnMissingArrayPropertyFirstNode() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> this.makeExtractions(this.missingArrayGraph)).withMessageContaining("Missing node property for property key `a` on node with id `0`.");
    }

    @Test
    void shouldFailOnMissingArrayPropertySecondNode() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> this.makeExtractions(this.missingArray2Graph)).withMessageContaining("Missing node property for property key `a` on node with id `1`.");
    }

    @Test
    void shouldFailOnUnequalLengths() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> this.makeExtractions(this.invalidGraph)).withMessageContaining("The property `a` contains arrays of differing lengths `1` and `2`.");
    }
}

