/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.core.helper;

import org.neo4j.gds.ml.core.ComputationContext;
import org.neo4j.gds.ml.core.Dimensions;
import org.neo4j.gds.ml.core.Variable;
import org.neo4j.gds.ml.core.functions.SingleParentVariable;
import org.neo4j.gds.ml.core.tensor.Scalar;
import org.neo4j.gds.ml.core.tensor.Tensor;

public class L2Norm<P extends Tensor<P>>
extends SingleParentVariable<P, Scalar> {
    public L2Norm(Variable<P> parent) {
        super(parent, Dimensions.scalar());
    }

    public Scalar apply(ComputationContext ctx) {
        return new Scalar(org.neo4j.gds.math.L2Norm.l2Norm((double[])ctx.data(this.parent).data()));
    }

    public P gradientForParent(ComputationContext ctx) {
        double gradientValue = ((Scalar)ctx.gradient((Variable)this)).value();
        double dataValue = ((Scalar)ctx.data((Variable)this)).value();
        return (P)ctx.data(this.parent).scalarMultiply(gradientValue / dataValue);
    }
}

