/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.core.helper;

import java.util.function.DoublePredicate;
import org.neo4j.gds.ml.core.tensor.Tensor;

public final class TensorTestUtils {
    private TensorTestUtils() {
    }

    public static boolean containsNaN(Tensor<?> tensor) {
        return TensorTestUtils.anyMatch(tensor, Double::isNaN);
    }

    public static boolean containsValidValues(Tensor<?> tensor) {
        return !TensorTestUtils.containsInfinity(tensor) && !TensorTestUtils.containsNaN(tensor);
    }

    private static boolean containsInfinity(Tensor<?> tensor) {
        return TensorTestUtils.anyMatch(tensor, Double::isInfinite);
    }

    public static boolean anyMatch(Tensor<?> tensor, DoublePredicate predicate) {
        for (int idx = 0; idx < tensor.totalSize(); ++idx) {
            if (!predicate.test(tensor.dataAt(idx))) continue;
            return true;
        }
        return false;
    }
}

