/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.model;

import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.model.ModelConfig;

@Generated(from="Model", generator="Immutables")
public final class ImmutableModel<DATA, CONFIG extends ModelConfig & BaseConfig, INFO extends ToMapConvertible>
implements Model<DATA, CONFIG, INFO> {
    private final String creator;
    private final List<String> sharedWith;
    private final String name;
    private final String algoType;
    private final GraphSchema graphSchema;
    @Nullable
    private final DATA data;
    private final CONFIG trainConfig;
    private final ZonedDateTime creationTime;
    private final INFO customInfo;
    private final Optional<Path> fileLocation;
    private final transient boolean loaded;
    private final transient boolean stored;
    private final transient boolean isPublished;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableModel(String creator, Iterable<String> sharedWith, String name, String algoType, GraphSchema graphSchema, @Nullable DATA data, CONFIG trainConfig, ZonedDateTime creationTime, INFO customInfo, Optional<Path> fileLocation) {
        this.creator = Objects.requireNonNull(creator, "creator");
        this.initShim.sharedWith(ImmutableModel.createUnmodifiableList(false, ImmutableModel.createSafeList(sharedWith, true, false)));
        this.name = Objects.requireNonNull(name, "name");
        this.algoType = Objects.requireNonNull(algoType, "algoType");
        this.graphSchema = Objects.requireNonNull(graphSchema, "graphSchema");
        this.data = data;
        this.trainConfig = (ModelConfig)Objects.requireNonNull(trainConfig, "trainConfig");
        this.initShim.creationTime(Objects.requireNonNull(creationTime, "creationTime"));
        this.customInfo = (ToMapConvertible)Objects.requireNonNull(customInfo, "customInfo");
        this.initShim.fileLocation(Objects.requireNonNull(fileLocation, "fileLocation"));
        this.sharedWith = this.initShim.sharedWith();
        this.creationTime = this.initShim.creationTime();
        this.fileLocation = this.initShim.fileLocation();
        this.loaded = this.initShim.loaded();
        this.stored = this.initShim.stored();
        this.isPublished = this.initShim.isPublished();
        this.initShim = null;
    }

    private ImmutableModel(Builder<DATA, CONFIG, INFO> builder) {
        this.creator = builder.creator;
        this.name = builder.name;
        this.algoType = builder.algoType;
        this.graphSchema = builder.graphSchema;
        this.data = builder.data;
        this.trainConfig = builder.trainConfig;
        this.customInfo = builder.customInfo;
        if (builder.sharedWithIsSet()) {
            this.initShim.sharedWith(builder.sharedWith == null ? Collections.emptyList() : ImmutableModel.createUnmodifiableList(true, builder.sharedWith));
        }
        if (builder.creationTime != null) {
            this.initShim.creationTime(builder.creationTime);
        }
        if (builder.fileLocation != null) {
            this.initShim.fileLocation(builder.fileLocation);
        }
        this.sharedWith = this.initShim.sharedWith();
        this.creationTime = this.initShim.creationTime();
        this.fileLocation = this.initShim.fileLocation();
        this.loaded = this.initShim.loaded();
        this.stored = this.initShim.stored();
        this.isPublished = this.initShim.isPublished();
        this.initShim = null;
    }

    private ImmutableModel(ImmutableModel<DATA, CONFIG, INFO> original, String creator, List<String> sharedWith, String name, String algoType, GraphSchema graphSchema, @Nullable DATA data, CONFIG trainConfig, ZonedDateTime creationTime, INFO customInfo, Optional<Path> fileLocation) {
        this.creator = creator;
        this.initShim.sharedWith(sharedWith);
        this.name = name;
        this.algoType = algoType;
        this.graphSchema = graphSchema;
        this.data = data;
        this.trainConfig = trainConfig;
        this.initShim.creationTime(creationTime);
        this.customInfo = customInfo;
        this.initShim.fileLocation(fileLocation);
        this.sharedWith = this.initShim.sharedWith();
        this.creationTime = this.initShim.creationTime();
        this.fileLocation = this.initShim.fileLocation();
        this.loaded = this.initShim.loaded();
        this.stored = this.initShim.stored();
        this.isPublished = this.initShim.isPublished();
        this.initShim = null;
    }

    private List<String> sharedWithInitialize() {
        return Model.super.sharedWith();
    }

    private ZonedDateTime creationTimeInitialize() {
        return Model.super.creationTime();
    }

    private Optional<Path> fileLocationInitialize() {
        return Model.super.fileLocation();
    }

    private boolean loadedInitialize() {
        return Model.super.loaded();
    }

    private boolean storedInitialize() {
        return Model.super.stored();
    }

    private boolean isPublishedInitialize() {
        return Model.super.isPublished();
    }

    @Override
    public String creator() {
        return this.creator;
    }

    @Override
    public List<String> sharedWith() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sharedWith() : this.sharedWith;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String algoType() {
        return this.algoType;
    }

    @Override
    public GraphSchema graphSchema() {
        return this.graphSchema;
    }

    @Override
    @Nullable
    public DATA data() {
        return this.data;
    }

    @Override
    public CONFIG trainConfig() {
        return this.trainConfig;
    }

    @Override
    public ZonedDateTime creationTime() {
        InitShim shim = this.initShim;
        return shim != null ? shim.creationTime() : this.creationTime;
    }

    @Override
    public INFO customInfo() {
        return this.customInfo;
    }

    @Override
    public Optional<Path> fileLocation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fileLocation() : this.fileLocation;
    }

    @Override
    public boolean loaded() {
        InitShim shim = this.initShim;
        return shim != null ? shim.loaded() : this.loaded;
    }

    @Override
    public boolean stored() {
        InitShim shim = this.initShim;
        return shim != null ? shim.stored() : this.stored;
    }

    @Override
    public boolean isPublished() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isPublished() : this.isPublished;
    }

    public final ImmutableModel<DATA, CONFIG, INFO> withCreator(String value) {
        String newValue = Objects.requireNonNull(value, "creator");
        if (this.creator.equals(newValue)) {
            return this;
        }
        return new ImmutableModel<DATA, CONFIG, INFO>(this, newValue, this.sharedWith, this.name, this.algoType, this.graphSchema, this.data, this.trainConfig, this.creationTime, this.customInfo, this.fileLocation);
    }

    public final ImmutableModel<DATA, CONFIG, INFO> withSharedWith(String ... elements) {
        List<String> newValue = ImmutableModel.createUnmodifiableList(false, ImmutableModel.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableModel<DATA, CONFIG, INFO>(this, this.creator, newValue, this.name, this.algoType, this.graphSchema, this.data, this.trainConfig, this.creationTime, this.customInfo, this.fileLocation);
    }

    public final ImmutableModel<DATA, CONFIG, INFO> withSharedWith(Iterable<String> elements) {
        if (this.sharedWith == elements) {
            return this;
        }
        List<String> newValue = ImmutableModel.createUnmodifiableList(false, ImmutableModel.createSafeList(elements, true, false));
        return new ImmutableModel<DATA, CONFIG, INFO>(this, this.creator, newValue, this.name, this.algoType, this.graphSchema, this.data, this.trainConfig, this.creationTime, this.customInfo, this.fileLocation);
    }

    public final ImmutableModel<DATA, CONFIG, INFO> withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableModel<DATA, CONFIG, INFO>(this, this.creator, this.sharedWith, newValue, this.algoType, this.graphSchema, this.data, this.trainConfig, this.creationTime, this.customInfo, this.fileLocation);
    }

    public final ImmutableModel<DATA, CONFIG, INFO> withAlgoType(String value) {
        String newValue = Objects.requireNonNull(value, "algoType");
        if (this.algoType.equals(newValue)) {
            return this;
        }
        return new ImmutableModel<DATA, CONFIG, INFO>(this, this.creator, this.sharedWith, this.name, newValue, this.graphSchema, this.data, this.trainConfig, this.creationTime, this.customInfo, this.fileLocation);
    }

    public final ImmutableModel<DATA, CONFIG, INFO> withGraphSchema(GraphSchema value) {
        if (this.graphSchema == value) {
            return this;
        }
        GraphSchema newValue = Objects.requireNonNull(value, "graphSchema");
        return new ImmutableModel<DATA, CONFIG, INFO>(this, this.creator, this.sharedWith, this.name, this.algoType, newValue, this.data, this.trainConfig, this.creationTime, this.customInfo, this.fileLocation);
    }

    public final ImmutableModel<DATA, CONFIG, INFO> withData(@Nullable DATA value) {
        if (this.data == value) {
            return this;
        }
        return new ImmutableModel<DATA, CONFIG, INFO>(this, this.creator, this.sharedWith, this.name, this.algoType, this.graphSchema, value, this.trainConfig, this.creationTime, this.customInfo, this.fileLocation);
    }

    public final ImmutableModel<DATA, CONFIG, INFO> withTrainConfig(CONFIG value) {
        if (this.trainConfig == value) {
            return this;
        }
        ModelConfig newValue = (ModelConfig)Objects.requireNonNull(value, "trainConfig");
        return new ImmutableModel<DATA, ModelConfig, INFO>(this, this.creator, this.sharedWith, this.name, this.algoType, this.graphSchema, this.data, newValue, this.creationTime, this.customInfo, this.fileLocation);
    }

    public final ImmutableModel<DATA, CONFIG, INFO> withCreationTime(ZonedDateTime value) {
        if (this.creationTime == value) {
            return this;
        }
        ZonedDateTime newValue = Objects.requireNonNull(value, "creationTime");
        return new ImmutableModel<DATA, CONFIG, INFO>(this, this.creator, this.sharedWith, this.name, this.algoType, this.graphSchema, this.data, this.trainConfig, newValue, this.customInfo, this.fileLocation);
    }

    public final ImmutableModel<DATA, CONFIG, INFO> withCustomInfo(INFO value) {
        if (this.customInfo == value) {
            return this;
        }
        ToMapConvertible newValue = (ToMapConvertible)Objects.requireNonNull(value, "customInfo");
        return new ImmutableModel<DATA, CONFIG, ToMapConvertible>(this, this.creator, this.sharedWith, this.name, this.algoType, this.graphSchema, this.data, this.trainConfig, this.creationTime, newValue, this.fileLocation);
    }

    public final ImmutableModel<DATA, CONFIG, INFO> withFileLocation(Optional<Path> value) {
        Optional<Path> newValue = Objects.requireNonNull(value, "fileLocation");
        if (this.fileLocation.equals(newValue)) {
            return this;
        }
        return new ImmutableModel<DATA, CONFIG, INFO>(this, this.creator, this.sharedWith, this.name, this.algoType, this.graphSchema, this.data, this.trainConfig, this.creationTime, this.customInfo, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableModel && this.equalTo((ImmutableModel)another);
    }

    private boolean equalTo(ImmutableModel<?, ?, ?> another) {
        return this.creator.equals(another.creator) && this.sharedWith.equals(another.sharedWith) && this.name.equals(another.name) && this.algoType.equals(another.algoType) && this.graphSchema.equals(another.graphSchema) && Objects.equals(this.data, another.data) && this.trainConfig.equals(another.trainConfig) && this.creationTime.equals(another.creationTime) && this.customInfo.equals(another.customInfo) && this.fileLocation.equals(another.fileLocation) && this.loaded == another.loaded && this.stored == another.stored && this.isPublished == another.isPublished;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.creator.hashCode();
        h += (h << 5) + this.sharedWith.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.algoType.hashCode();
        h += (h << 5) + this.graphSchema.hashCode();
        h += (h << 5) + Objects.hashCode(this.data);
        h += (h << 5) + this.trainConfig.hashCode();
        h += (h << 5) + this.creationTime.hashCode();
        h += (h << 5) + this.customInfo.hashCode();
        h += (h << 5) + this.fileLocation.hashCode();
        h += (h << 5) + Boolean.hashCode(this.loaded);
        h += (h << 5) + Boolean.hashCode(this.stored);
        h += (h << 5) + Boolean.hashCode(this.isPublished);
        return h;
    }

    public String toString() {
        return "Model{creator=" + this.creator + ", sharedWith=" + this.sharedWith + ", name=" + this.name + ", algoType=" + this.algoType + ", graphSchema=" + this.graphSchema + ", data=" + this.data + ", trainConfig=" + this.trainConfig + ", creationTime=" + this.creationTime + ", customInfo=" + this.customInfo + ", fileLocation=" + this.fileLocation + ", loaded=" + this.loaded + ", stored=" + this.stored + ", isPublished=" + this.isPublished + "}";
    }

    public static <DATA, CONFIG extends ModelConfig & BaseConfig, INFO extends ToMapConvertible> Model<DATA, CONFIG, INFO> of(String creator, List<String> sharedWith, String name, String algoType, GraphSchema graphSchema, @Nullable DATA data, CONFIG trainConfig, ZonedDateTime creationTime, INFO customInfo, Optional<Path> fileLocation) {
        return ImmutableModel.of(creator, sharedWith, name, algoType, graphSchema, data, trainConfig, creationTime, customInfo, fileLocation);
    }

    public static <DATA, CONFIG extends ModelConfig & BaseConfig, INFO extends ToMapConvertible> Model<DATA, CONFIG, INFO> of(String creator, Iterable<String> sharedWith, String name, String algoType, GraphSchema graphSchema, @Nullable DATA data, CONFIG trainConfig, ZonedDateTime creationTime, INFO customInfo, Optional<Path> fileLocation) {
        return new ImmutableModel<DATA, CONFIG, INFO>(creator, sharedWith, name, algoType, graphSchema, data, trainConfig, creationTime, customInfo, fileLocation);
    }

    public static <DATA, CONFIG extends ModelConfig & BaseConfig, INFO extends ToMapConvertible> Model<DATA, CONFIG, INFO> copyOf(Model<DATA, CONFIG, INFO> instance) {
        if (instance instanceof ImmutableModel) {
            return (ImmutableModel)instance;
        }
        return ImmutableModel.builder().from(instance).build();
    }

    public static <DATA, CONFIG extends ModelConfig & BaseConfig, INFO extends ToMapConvertible> Builder<DATA, CONFIG, INFO> builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Model", generator="Immutables")
    public static final class Builder<DATA, CONFIG extends ModelConfig & BaseConfig, INFO extends ToMapConvertible> {
        private static final long INIT_BIT_CREATOR = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_ALGO_TYPE = 4L;
        private static final long INIT_BIT_GRAPH_SCHEMA = 8L;
        private static final long INIT_BIT_TRAIN_CONFIG = 16L;
        private static final long INIT_BIT_CUSTOM_INFO = 32L;
        private static final long OPT_BIT_SHARED_WITH = 1L;
        private long initBits = 63L;
        private long optBits;
        private String creator;
        private List<String> sharedWith = null;
        private String name;
        private String algoType;
        private GraphSchema graphSchema;
        private DATA data;
        private CONFIG trainConfig;
        private ZonedDateTime creationTime;
        private INFO customInfo;
        private Optional<Path> fileLocation;

        private Builder() {
        }

        public final Builder<DATA, CONFIG, INFO> from(Model<DATA, CONFIG, INFO> instance) {
            Objects.requireNonNull(instance, "instance");
            this.creator(instance.creator());
            this.addAllSharedWith(instance.sharedWith());
            this.name(instance.name());
            this.algoType(instance.algoType());
            this.graphSchema(instance.graphSchema());
            @Nullable DATA dataValue = instance.data();
            if (dataValue != null) {
                this.data(dataValue);
            }
            this.trainConfig(instance.trainConfig());
            this.creationTime(instance.creationTime());
            this.customInfo(instance.customInfo());
            this.fileLocation(instance.fileLocation());
            return this;
        }

        public final Builder<DATA, CONFIG, INFO> creator(String creator) {
            this.creator = Objects.requireNonNull(creator, "creator");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<DATA, CONFIG, INFO> addSharedWith(String element) {
            if (this.sharedWith == null) {
                this.sharedWith = new ArrayList<String>();
            }
            this.sharedWith.add(Objects.requireNonNull(element, "sharedWith element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder<DATA, CONFIG, INFO> addSharedWith(String ... elements) {
            if (this.sharedWith == null) {
                this.sharedWith = new ArrayList<String>();
            }
            for (String element : elements) {
                this.sharedWith.add(Objects.requireNonNull(element, "sharedWith element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder<DATA, CONFIG, INFO> sharedWith(Iterable<String> elements) {
            this.sharedWith = new ArrayList<String>();
            return this.addAllSharedWith(elements);
        }

        public final Builder<DATA, CONFIG, INFO> addAllSharedWith(Iterable<String> elements) {
            Objects.requireNonNull(elements, "sharedWith element");
            if (this.sharedWith == null) {
                this.sharedWith = new ArrayList<String>();
            }
            for (String element : elements) {
                this.sharedWith.add(Objects.requireNonNull(element, "sharedWith element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder<DATA, CONFIG, INFO> name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<DATA, CONFIG, INFO> algoType(String algoType) {
            this.algoType = Objects.requireNonNull(algoType, "algoType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder<DATA, CONFIG, INFO> graphSchema(GraphSchema graphSchema) {
            this.graphSchema = Objects.requireNonNull(graphSchema, "graphSchema");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder<DATA, CONFIG, INFO> data(@Nullable DATA data) {
            this.data = data;
            return this;
        }

        public final Builder<DATA, CONFIG, INFO> trainConfig(CONFIG trainConfig) {
            this.trainConfig = (ModelConfig)Objects.requireNonNull(trainConfig, "trainConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder<DATA, CONFIG, INFO> creationTime(ZonedDateTime creationTime) {
            this.creationTime = Objects.requireNonNull(creationTime, "creationTime");
            return this;
        }

        public final Builder<DATA, CONFIG, INFO> customInfo(INFO customInfo) {
            this.customInfo = (ToMapConvertible)Objects.requireNonNull(customInfo, "customInfo");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder<DATA, CONFIG, INFO> fileLocation(Optional<Path> fileLocation) {
            this.fileLocation = Objects.requireNonNull(fileLocation, "fileLocation");
            return this;
        }

        public Builder<DATA, CONFIG, INFO> clear() {
            this.initBits = 63L;
            this.optBits = 0L;
            this.creator = null;
            if (this.sharedWith != null) {
                this.sharedWith.clear();
            }
            this.name = null;
            this.algoType = null;
            this.graphSchema = null;
            this.data = null;
            this.trainConfig = null;
            this.creationTime = null;
            this.customInfo = null;
            this.fileLocation = null;
            return this;
        }

        public Model<DATA, CONFIG, INFO> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableModel(this);
        }

        private boolean sharedWithIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("creator");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("algoType");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("graphSchema");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("trainConfig");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("customInfo");
            }
            return "Cannot build Model, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="Model", generator="Immutables")
    private final class InitShim {
        private byte sharedWithBuildStage = 0;
        private List<String> sharedWith;
        private byte creationTimeBuildStage = 0;
        private ZonedDateTime creationTime;
        private byte fileLocationBuildStage = 0;
        private Optional<Path> fileLocation;
        private byte loadedBuildStage = 0;
        private boolean loaded;
        private byte storedBuildStage = 0;
        private boolean stored;
        private byte isPublishedBuildStage = 0;
        private boolean isPublished;

        private InitShim() {
        }

        List<String> sharedWith() {
            if (this.sharedWithBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sharedWithBuildStage == 0) {
                this.sharedWithBuildStage = (byte)-1;
                this.sharedWith = ImmutableModel.createUnmodifiableList(false, ImmutableModel.createSafeList(ImmutableModel.this.sharedWithInitialize(), true, false));
                this.sharedWithBuildStage = 1;
            }
            return this.sharedWith;
        }

        void sharedWith(List<String> sharedWith) {
            this.sharedWith = sharedWith;
            this.sharedWithBuildStage = 1;
        }

        ZonedDateTime creationTime() {
            if (this.creationTimeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.creationTimeBuildStage == 0) {
                this.creationTimeBuildStage = (byte)-1;
                this.creationTime = Objects.requireNonNull(ImmutableModel.this.creationTimeInitialize(), "creationTime");
                this.creationTimeBuildStage = 1;
            }
            return this.creationTime;
        }

        void creationTime(ZonedDateTime creationTime) {
            this.creationTime = creationTime;
            this.creationTimeBuildStage = 1;
        }

        Optional<Path> fileLocation() {
            if (this.fileLocationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fileLocationBuildStage == 0) {
                this.fileLocationBuildStage = (byte)-1;
                this.fileLocation = Objects.requireNonNull(ImmutableModel.this.fileLocationInitialize(), "fileLocation");
                this.fileLocationBuildStage = 1;
            }
            return this.fileLocation;
        }

        void fileLocation(Optional<Path> fileLocation) {
            this.fileLocation = fileLocation;
            this.fileLocationBuildStage = 1;
        }

        boolean loaded() {
            if (this.loadedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.loadedBuildStage == 0) {
                this.loadedBuildStage = (byte)-1;
                this.loaded = ImmutableModel.this.loadedInitialize();
                this.loadedBuildStage = 1;
            }
            return this.loaded;
        }

        boolean stored() {
            if (this.storedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.storedBuildStage == 0) {
                this.storedBuildStage = (byte)-1;
                this.stored = ImmutableModel.this.storedInitialize();
                this.storedBuildStage = 1;
            }
            return this.stored;
        }

        boolean isPublished() {
            if (this.isPublishedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isPublishedBuildStage == 0) {
                this.isPublishedBuildStage = (byte)-1;
                this.isPublished = ImmutableModel.this.isPublishedInitialize();
                this.isPublishedBuildStage = 1;
            }
            return this.isPublished;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sharedWithBuildStage == -1) {
                attributes.add("sharedWith");
            }
            if (this.creationTimeBuildStage == -1) {
                attributes.add("creationTime");
            }
            if (this.fileLocationBuildStage == -1) {
                attributes.add("fileLocation");
            }
            if (this.loadedBuildStage == -1) {
                attributes.add("loaded");
            }
            if (this.storedBuildStage == -1) {
                attributes.add("stored");
            }
            if (this.isPublishedBuildStage == -1) {
                attributes.add("isPublished");
            }
            return "Cannot build Model, attribute initializers form cycle " + attributes;
        }
    }
}

