/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.model;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.core.model.ModelMetaData;
import org.neo4j.gds.model.ModelConfig;

@Generated(from="ModelMetaData", generator="Immutables")
public final class ImmutableModelMetaData<CONFIG extends ModelConfig, INFO extends ToMapConvertible>
implements ModelMetaData<CONFIG, INFO> {
    private final String creator;
    private final List<String> sharedWith;
    private final String name;
    private final String algoType;
    private final GraphSchema graphSchema;
    private final CONFIG trainConfig;
    private final ZonedDateTime creationTime;
    private final INFO customInfo;

    private ImmutableModelMetaData(String creator, Iterable<String> sharedWith, String name, String algoType, GraphSchema graphSchema, CONFIG trainConfig, ZonedDateTime creationTime, INFO customInfo) {
        this.creator = Objects.requireNonNull(creator, "creator");
        this.sharedWith = ImmutableModelMetaData.createUnmodifiableList(false, ImmutableModelMetaData.createSafeList(sharedWith, true, false));
        this.name = Objects.requireNonNull(name, "name");
        this.algoType = Objects.requireNonNull(algoType, "algoType");
        this.graphSchema = Objects.requireNonNull(graphSchema, "graphSchema");
        this.trainConfig = (ModelConfig)Objects.requireNonNull(trainConfig, "trainConfig");
        this.creationTime = Objects.requireNonNull(creationTime, "creationTime");
        this.customInfo = (ToMapConvertible)Objects.requireNonNull(customInfo, "customInfo");
    }

    private ImmutableModelMetaData(ImmutableModelMetaData<CONFIG, INFO> original, String creator, List<String> sharedWith, String name, String algoType, GraphSchema graphSchema, CONFIG trainConfig, ZonedDateTime creationTime, INFO customInfo) {
        this.creator = creator;
        this.sharedWith = sharedWith;
        this.name = name;
        this.algoType = algoType;
        this.graphSchema = graphSchema;
        this.trainConfig = trainConfig;
        this.creationTime = creationTime;
        this.customInfo = customInfo;
    }

    @Override
    public String creator() {
        return this.creator;
    }

    @Override
    public List<String> sharedWith() {
        return this.sharedWith;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String algoType() {
        return this.algoType;
    }

    @Override
    public GraphSchema graphSchema() {
        return this.graphSchema;
    }

    @Override
    public CONFIG trainConfig() {
        return this.trainConfig;
    }

    @Override
    public ZonedDateTime creationTime() {
        return this.creationTime;
    }

    @Override
    public INFO customInfo() {
        return this.customInfo;
    }

    public final ImmutableModelMetaData<CONFIG, INFO> withCreator(String value) {
        String newValue = Objects.requireNonNull(value, "creator");
        if (this.creator.equals(newValue)) {
            return this;
        }
        return new ImmutableModelMetaData<CONFIG, INFO>(this, newValue, this.sharedWith, this.name, this.algoType, this.graphSchema, this.trainConfig, this.creationTime, this.customInfo);
    }

    public final ImmutableModelMetaData<CONFIG, INFO> withSharedWith(String ... elements) {
        List<String> newValue = ImmutableModelMetaData.createUnmodifiableList(false, ImmutableModelMetaData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableModelMetaData<CONFIG, INFO>(this, this.creator, newValue, this.name, this.algoType, this.graphSchema, this.trainConfig, this.creationTime, this.customInfo);
    }

    public final ImmutableModelMetaData<CONFIG, INFO> withSharedWith(Iterable<String> elements) {
        if (this.sharedWith == elements) {
            return this;
        }
        List<String> newValue = ImmutableModelMetaData.createUnmodifiableList(false, ImmutableModelMetaData.createSafeList(elements, true, false));
        return new ImmutableModelMetaData<CONFIG, INFO>(this, this.creator, newValue, this.name, this.algoType, this.graphSchema, this.trainConfig, this.creationTime, this.customInfo);
    }

    public final ImmutableModelMetaData<CONFIG, INFO> withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableModelMetaData<CONFIG, INFO>(this, this.creator, this.sharedWith, newValue, this.algoType, this.graphSchema, this.trainConfig, this.creationTime, this.customInfo);
    }

    public final ImmutableModelMetaData<CONFIG, INFO> withAlgoType(String value) {
        String newValue = Objects.requireNonNull(value, "algoType");
        if (this.algoType.equals(newValue)) {
            return this;
        }
        return new ImmutableModelMetaData<CONFIG, INFO>(this, this.creator, this.sharedWith, this.name, newValue, this.graphSchema, this.trainConfig, this.creationTime, this.customInfo);
    }

    public final ImmutableModelMetaData<CONFIG, INFO> withGraphSchema(GraphSchema value) {
        if (this.graphSchema == value) {
            return this;
        }
        GraphSchema newValue = Objects.requireNonNull(value, "graphSchema");
        return new ImmutableModelMetaData<CONFIG, INFO>(this, this.creator, this.sharedWith, this.name, this.algoType, newValue, this.trainConfig, this.creationTime, this.customInfo);
    }

    public final ImmutableModelMetaData<CONFIG, INFO> withTrainConfig(CONFIG value) {
        if (this.trainConfig == value) {
            return this;
        }
        ModelConfig newValue = (ModelConfig)Objects.requireNonNull(value, "trainConfig");
        return new ImmutableModelMetaData<ModelConfig, INFO>(this, this.creator, this.sharedWith, this.name, this.algoType, this.graphSchema, newValue, this.creationTime, this.customInfo);
    }

    public final ImmutableModelMetaData<CONFIG, INFO> withCreationTime(ZonedDateTime value) {
        if (this.creationTime == value) {
            return this;
        }
        ZonedDateTime newValue = Objects.requireNonNull(value, "creationTime");
        return new ImmutableModelMetaData<CONFIG, INFO>(this, this.creator, this.sharedWith, this.name, this.algoType, this.graphSchema, this.trainConfig, newValue, this.customInfo);
    }

    public final ImmutableModelMetaData<CONFIG, INFO> withCustomInfo(INFO value) {
        if (this.customInfo == value) {
            return this;
        }
        ToMapConvertible newValue = (ToMapConvertible)Objects.requireNonNull(value, "customInfo");
        return new ImmutableModelMetaData<CONFIG, ToMapConvertible>(this, this.creator, this.sharedWith, this.name, this.algoType, this.graphSchema, this.trainConfig, this.creationTime, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableModelMetaData && this.equalTo((ImmutableModelMetaData)another);
    }

    private boolean equalTo(ImmutableModelMetaData<?, ?> another) {
        return this.creator.equals(another.creator) && this.sharedWith.equals(another.sharedWith) && this.name.equals(another.name) && this.algoType.equals(another.algoType) && this.graphSchema.equals(another.graphSchema) && this.trainConfig.equals(another.trainConfig) && this.creationTime.equals(another.creationTime) && this.customInfo.equals(another.customInfo);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.creator.hashCode();
        h += (h << 5) + this.sharedWith.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.algoType.hashCode();
        h += (h << 5) + this.graphSchema.hashCode();
        h += (h << 5) + this.trainConfig.hashCode();
        h += (h << 5) + this.creationTime.hashCode();
        h += (h << 5) + this.customInfo.hashCode();
        return h;
    }

    public String toString() {
        return "ModelMetaData{creator=" + this.creator + ", sharedWith=" + this.sharedWith + ", name=" + this.name + ", algoType=" + this.algoType + ", graphSchema=" + this.graphSchema + ", trainConfig=" + this.trainConfig + ", creationTime=" + this.creationTime + ", customInfo=" + this.customInfo + "}";
    }

    public static <CONFIG extends ModelConfig, INFO extends ToMapConvertible> ModelMetaData<CONFIG, INFO> of(String creator, List<String> sharedWith, String name, String algoType, GraphSchema graphSchema, CONFIG trainConfig, ZonedDateTime creationTime, INFO customInfo) {
        return ImmutableModelMetaData.of(creator, sharedWith, name, algoType, graphSchema, trainConfig, creationTime, customInfo);
    }

    public static <CONFIG extends ModelConfig, INFO extends ToMapConvertible> ModelMetaData<CONFIG, INFO> of(String creator, Iterable<String> sharedWith, String name, String algoType, GraphSchema graphSchema, CONFIG trainConfig, ZonedDateTime creationTime, INFO customInfo) {
        return new ImmutableModelMetaData<CONFIG, INFO>(creator, sharedWith, name, algoType, graphSchema, trainConfig, creationTime, customInfo);
    }

    public static <CONFIG extends ModelConfig, INFO extends ToMapConvertible> ModelMetaData<CONFIG, INFO> copyOf(ModelMetaData<CONFIG, INFO> instance) {
        if (instance instanceof ImmutableModelMetaData) {
            return (ImmutableModelMetaData)instance;
        }
        return ImmutableModelMetaData.builder().from(instance).build();
    }

    public static <CONFIG extends ModelConfig, INFO extends ToMapConvertible> Builder<CONFIG, INFO> builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ModelMetaData", generator="Immutables")
    public static final class Builder<CONFIG extends ModelConfig, INFO extends ToMapConvertible> {
        private static final long INIT_BIT_CREATOR = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_ALGO_TYPE = 4L;
        private static final long INIT_BIT_GRAPH_SCHEMA = 8L;
        private static final long INIT_BIT_TRAIN_CONFIG = 16L;
        private static final long INIT_BIT_CREATION_TIME = 32L;
        private static final long INIT_BIT_CUSTOM_INFO = 64L;
        private long initBits = 127L;
        private String creator;
        private List<String> sharedWith = null;
        private String name;
        private String algoType;
        private GraphSchema graphSchema;
        private CONFIG trainConfig;
        private ZonedDateTime creationTime;
        private INFO customInfo;

        private Builder() {
        }

        public final Builder<CONFIG, INFO> from(ModelMetaData<CONFIG, INFO> instance) {
            Objects.requireNonNull(instance, "instance");
            this.creator(instance.creator());
            this.addAllSharedWith(instance.sharedWith());
            this.name(instance.name());
            this.algoType(instance.algoType());
            this.graphSchema(instance.graphSchema());
            this.trainConfig(instance.trainConfig());
            this.creationTime(instance.creationTime());
            this.customInfo(instance.customInfo());
            return this;
        }

        public final Builder<CONFIG, INFO> creator(String creator) {
            this.creator = Objects.requireNonNull(creator, "creator");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<CONFIG, INFO> addSharedWith(String element) {
            if (this.sharedWith == null) {
                this.sharedWith = new ArrayList<String>();
            }
            this.sharedWith.add(Objects.requireNonNull(element, "sharedWith element"));
            return this;
        }

        public final Builder<CONFIG, INFO> addSharedWith(String ... elements) {
            if (this.sharedWith == null) {
                this.sharedWith = new ArrayList<String>();
            }
            for (String element : elements) {
                this.sharedWith.add(Objects.requireNonNull(element, "sharedWith element"));
            }
            return this;
        }

        public final Builder<CONFIG, INFO> sharedWith(Iterable<String> elements) {
            this.sharedWith = new ArrayList<String>();
            return this.addAllSharedWith(elements);
        }

        public final Builder<CONFIG, INFO> addAllSharedWith(Iterable<String> elements) {
            Objects.requireNonNull(elements, "sharedWith element");
            if (this.sharedWith == null) {
                this.sharedWith = new ArrayList<String>();
            }
            for (String element : elements) {
                this.sharedWith.add(Objects.requireNonNull(element, "sharedWith element"));
            }
            return this;
        }

        public final Builder<CONFIG, INFO> name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<CONFIG, INFO> algoType(String algoType) {
            this.algoType = Objects.requireNonNull(algoType, "algoType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder<CONFIG, INFO> graphSchema(GraphSchema graphSchema) {
            this.graphSchema = Objects.requireNonNull(graphSchema, "graphSchema");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder<CONFIG, INFO> trainConfig(CONFIG trainConfig) {
            this.trainConfig = (ModelConfig)Objects.requireNonNull(trainConfig, "trainConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder<CONFIG, INFO> creationTime(ZonedDateTime creationTime) {
            this.creationTime = Objects.requireNonNull(creationTime, "creationTime");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder<CONFIG, INFO> customInfo(INFO customInfo) {
            this.customInfo = (ToMapConvertible)Objects.requireNonNull(customInfo, "customInfo");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public Builder<CONFIG, INFO> clear() {
            this.initBits = 127L;
            this.creator = null;
            if (this.sharedWith != null) {
                this.sharedWith.clear();
            }
            this.name = null;
            this.algoType = null;
            this.graphSchema = null;
            this.trainConfig = null;
            this.creationTime = null;
            this.customInfo = null;
            return this;
        }

        public ModelMetaData<CONFIG, INFO> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableModelMetaData<CONFIG, INFO>(null, this.creator, this.sharedWith == null ? Collections.emptyList() : ImmutableModelMetaData.createUnmodifiableList(true, this.sharedWith), this.name, this.algoType, this.graphSchema, this.trainConfig, this.creationTime, this.customInfo);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("creator");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("algoType");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("graphSchema");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("trainConfig");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("creationTime");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("customInfo");
            }
            return "Cannot build ModelMetaData, some of required attributes are not set " + attributes;
        }
    }
}

