/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.model;

import java.nio.file.Path;
import java.time.Clock;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.core.model.ImmutableModel;
import org.neo4j.gds.model.ModelConfig;

@ValueClass
public interface Model<DATA, CONFIG extends ModelConfig & BaseConfig, INFO extends ToMapConvertible> {
    public static final String ALL_USERS = "*";
    public static final String PUBLIC_MODEL_SUFFIX = "_public";

    private static ZonedDateTime now() {
        ZoneId zoneId = (ZoneId)Config.EMPTY.get(GraphDatabaseSettings.db_temporal_timezone);
        return ZonedDateTime.now(Clock.system(zoneId != null ? zoneId : ZoneId.systemDefault()));
    }

    public String creator();

    @Value.Default
    default public List<String> sharedWith() {
        return List.of();
    }

    public String name();

    public String algoType();

    public GraphSchema graphSchema();

    @Nullable
    public DATA data();

    public CONFIG trainConfig();

    @Value.Default
    default public ZonedDateTime creationTime() {
        return Model.now();
    }

    public INFO customInfo();

    public Optional<Path> fileLocation();

    @Value.Derived
    default public boolean loaded() {
        return this.data() != null;
    }

    @Value.Derived
    default public boolean stored() {
        return this.fileLocation().isPresent();
    }

    @Value.Derived
    default public boolean isPublished() {
        return this.sharedWith().contains(ALL_USERS);
    }

    public static <D, C extends ModelConfig & BaseConfig, INFO extends ToMapConvertible> Model<D, C, INFO> of(String creator, String name, String algoType, GraphSchema graphSchema, D modelData, C trainConfig, INFO customInfo) {
        return ImmutableModel.builder().creator(creator).name(name).algoType(algoType).graphSchema(graphSchema).data(modelData).trainConfig(trainConfig).customInfo(customInfo).build();
    }
}

