/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat._44drop010;

import java.util.Iterator;
import org.neo4j.common.EntityType;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;

final class NodeLabelIndexLookupImpl {
    static boolean hasNodeLabelIndex(KernelTransaction transaction) {
        return NodeLabelIndexLookupImpl.findUsableMatchingIndex(transaction, (SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE)) != IndexDescriptor.NO_INDEX;
    }

    static IndexDescriptor findUsableMatchingIndex(KernelTransaction transaction, SchemaDescriptor schemaDescriptor) {
        SchemaRead schemaRead = transaction.schemaRead();
        Iterator iterator = schemaRead.index(schemaDescriptor);
        while (iterator.hasNext()) {
            IndexDescriptor index = (IndexDescriptor)iterator.next();
            if (index.getIndexType() != IndexType.LOOKUP || !NodeLabelIndexLookupImpl.indexIsOnline(schemaRead, index)) continue;
            return index;
        }
        return IndexDescriptor.NO_INDEX;
    }

    private static boolean indexIsOnline(SchemaRead schemaRead, IndexDescriptor index) {
        InternalIndexState state = InternalIndexState.FAILED;
        try {
            state = schemaRead.indexGetState(index);
        }
        catch (IndexNotFoundKernelException indexNotFoundKernelException) {
            // empty catch block
        }
        return state == InternalIndexState.ONLINE;
    }

    private NodeLabelIndexLookupImpl() {
    }
}

