/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat._44drop010;

import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.neo4j.gds.annotation.SuppressForbidden;
import org.neo4j.gds.compat.TestLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;

public class TestLogImpl
implements TestLog {
    private final ConcurrentMap<String, ConcurrentLinkedQueue<String>> messages = new ConcurrentHashMap<String, ConcurrentLinkedQueue<String>>(3);

    TestLogImpl() {
    }

    public void assertContainsMessage(String level, String fragment) {
        if (!this.containsMessage(level, fragment)) {
            throw new RuntimeException(String.format(Locale.US, "Expected log output to contain `%s` for log level `%s`%nLog messages:%n%s", fragment, level, String.join((CharSequence)"\n", (Iterable)this.messages.get(level))));
        }
    }

    public boolean containsMessage(String level, String fragment) {
        ConcurrentLinkedQueue messageList = this.messages.getOrDefault(level, new ConcurrentLinkedQueue());
        return messageList.stream().anyMatch(message -> message.contains(fragment));
    }

    public boolean hasMessages(String level) {
        return !this.messages.getOrDefault(level, new ConcurrentLinkedQueue()).isEmpty();
    }

    public ArrayList<String> getMessages(String level) {
        return new ArrayList<String>(this.messages.getOrDefault(level, new ConcurrentLinkedQueue()));
    }

    @SuppressForbidden(reason="test log can print")
    public void printMessages() {
        System.out.println("TestLog Messages: " + this.messages);
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void debug(String message) {
        this.logMessage("debug", message);
    }

    public void debug(String message, Throwable throwable) {
        this.debug(String.format(Locale.US, "%s - %s", message, throwable.getMessage()));
    }

    public void debug(String format, Object ... arguments) {
        this.debug(String.format(Locale.US, format, arguments));
    }

    public void info(String message) {
        this.logMessage("info", message);
    }

    public void info(String message, Throwable throwable) {
        this.info(String.format(Locale.US, "%s - %s", message, throwable.getMessage()));
    }

    public void info(String format, Object ... arguments) {
        this.info(String.format(Locale.US, format, arguments));
    }

    public void warn(String message) {
        this.logMessage("warn", message);
    }

    public void warn(String message, Throwable throwable) {
        this.warn(String.format(Locale.US, "%s - %s", message, throwable.getMessage()));
    }

    public void warn(String format, Object ... arguments) {
        this.warn(String.format(Locale.US, format, arguments));
    }

    public void error(String message) {
        this.logMessage("error", message);
    }

    public void error(String message, Throwable throwable) {
        this.error(String.format(Locale.US, "%s - %s", message, throwable.getMessage()));
    }

    public void error(String format, Object ... arguments) {
        this.error(String.format(Locale.US, format, arguments));
    }

    public void bulk(Consumer<Log> consumer) {
    }

    public Logger debugLogger() {
        throw new UnsupportedOperationException();
    }

    public Logger infoLogger() {
        throw new UnsupportedOperationException();
    }

    public Logger warnLogger() {
        throw new UnsupportedOperationException();
    }

    public Logger errorLogger() {
        throw new UnsupportedOperationException();
    }

    private void logMessage(String level, String message) {
        this.messages.computeIfAbsent(level, ignore -> new ConcurrentLinkedQueue()).add(message);
    }
}

