/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.io.output.WriterOutputStream;
import org.immutables.builder.Builder;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.logging.log4j.Neo4jLoggerContext;

public final class LogBuilders {
    @Builder.Factory
    public static Log outputStreamLog(@Builder.Parameter OutputStream outputStream, Optional<Level> level, Optional<ZoneId> zoneId, Optional<String> category) {
        LogTimeZone logTimeZone = Arrays.stream(LogTimeZone.values()).filter(tz -> tz.getZoneId().equals(zoneId.orElse(ZoneOffset.UTC))).findAny().orElseThrow(() -> new IllegalArgumentException("Can only log in UTC or " + LogTimeZone.SYSTEM.getZoneId()));
        Neo4jLoggerContext context = LogConfig.createBuilder((OutputStream)outputStream, (Level)level.orElse(Level.INFO)).withCategory(category.isPresent()).withTimezone(logTimeZone).build();
        return new Log4jLogProvider(context).getLog(category.orElse(""));
    }

    @Builder.Factory
    public static Log writerLog(@Builder.Parameter Writer writer, Optional<Level> level, Optional<ZoneId> zoneId, Optional<String> category) {
        PrintWriter printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        WriterOutputStream outStream = new WriterOutputStream((Writer)printWriter, StandardCharsets.UTF_8);
        return LogBuilders.outputStreamLog((OutputStream)outStream, level, zoneId, category);
    }

    private LogBuilders() {
        throw new UnsupportedOperationException("No instances");
    }
}

