/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.gds.compat.DatabaseMode;
import org.neo4j.gds.compat.ImmutableSetting;
import org.neo4j.gds.compat.ProxyUtil;
import org.neo4j.gds.compat.Setting;
import org.neo4j.gds.compat.SettingProxyApi;
import org.neo4j.gds.compat.SettingProxyFactory;
import org.neo4j.graphdb.GraphDatabaseService;

public final class SettingProxy {
    private static final SettingProxyApi IMPL = (SettingProxyApi)ProxyUtil.findProxy(SettingProxyFactory.class, (ProxyUtil.MayLogToStdout)ProxyUtil.MayLogToStdout.NO);

    public static <T> Setting.Builder<T> newBuilder(String name, SettingValueParser<T> parser, @Nullable T defaultValue) {
        return ImmutableSetting.builder((String)name, parser, defaultValue).convert(arg_0 -> ((SettingProxyApi)IMPL).setting(arg_0));
    }

    public static DatabaseMode databaseMode(Config config, GraphDatabaseService databaseService) {
        return IMPL.databaseMode(config, databaseService);
    }

    @TestOnly
    public static void setDatabaseMode(Config config, DatabaseMode databaseMode, GraphDatabaseService databaseService) {
        IMPL.setDatabaseMode(config, databaseMode, databaseService);
    }

    public static String secondaryModeName() {
        return IMPL.secondaryModeName();
    }

    private SettingProxy() {
    }
}

