/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.core.StringSimilarity;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.model.ModelCatalogListener;
import org.neo4j.gds.core.model.OpenUserCatalog;
import org.neo4j.gds.model.ModelConfig;

public final class OpenModelCatalog
implements ModelCatalog {
    private final Map<String, OpenUserCatalog> userCatalogs = new ConcurrentHashMap<String, OpenUserCatalog>();
    private final Set<ModelCatalogListener> listeners = new HashSet<ModelCatalogListener>();

    public void registerListener(ModelCatalogListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(ModelCatalogListener listener) {
        this.listeners.remove(listener);
    }

    public void set(Model<?, ?, ?> model) {
        this.userCatalogs.compute(model.creator(), (user, userCatalog) -> {
            if (userCatalog == null) {
                userCatalog = new OpenUserCatalog();
            }
            userCatalog.set(model);
            return userCatalog;
        });
        this.listeners.forEach(listener -> listener.onInsert(model));
    }

    public <D, C extends ModelConfig, I extends ToMapConvertible> Model<D, C, I> get(String username, String modelName, Class<D> dataClass, Class<C> configClass, Class<I> infoClass) {
        OpenUserCatalog userCatalog = this.getUserCatalog(username);
        Model<D, C, I> model = userCatalog.get(modelName, dataClass, configClass, infoClass);
        if (model == null) {
            throw new NoSuchElementException(StringSimilarity.prettySuggestions((String)OpenModelCatalog.formatWithLocale("Model with name `%s` does not exist.", modelName), (CharSequence)modelName, userCatalog.availableModelNames()));
        }
        return model;
    }

    public Model<?, ?, ?> getUntypedOrThrow(String username, String modelName) {
        return this.getUntyped(username, modelName, true);
    }

    @Nullable
    public Model<?, ?, ?> getUntyped(String username, String modelName) {
        return this.getUntyped(username, modelName, false);
    }

    public Stream<Model<?, ?, ?>> getAllModels() {
        return this.userCatalogs.entrySet().stream().flatMap(entry -> ((OpenUserCatalog)entry.getValue()).streamModels());
    }

    public long modelCount() {
        return this.userCatalogs.values().stream().mapToLong(OpenUserCatalog::size).sum();
    }

    public boolean exists(String username, String modelName) {
        return this.getUserCatalog(username).exists(modelName);
    }

    public Model<?, ?, ?> dropOrThrow(String username, String modelName) {
        return this.drop(username, modelName, true);
    }

    @Nullable
    public Model<?, ?, ?> drop(String username, String modelName) {
        return this.drop(username, modelName, false);
    }

    public Collection<Model<?, ?, ?>> list(String username) {
        return new ArrayList(this.getUserCatalog(username).list());
    }

    public Model<?, ?, ?> publish(String username, String modelName) {
        throw new IllegalStateException("Publishing models is not available in openGDS. Please consider licensing the Graph Data Science library. See documentation at https://neo4j.com/docs/graph-data-science/");
    }

    public boolean isEmpty() {
        return this.userCatalogs.values().stream().allMatch(userCatalog -> userCatalog.list().isEmpty());
    }

    public void removeAllLoadedModels() {
        this.userCatalogs.clear();
    }

    public void verifyModelCanBeStored(String username, String modelName, String modelType) {
        this.getUserCatalog(username).verifyModelCanBeStored(modelName, modelType);
    }

    @Contract(value="_, _, true -> !null")
    @Nullable
    private Model<?, ?, ?> getUntyped(String username, String modelName, boolean failOnMissing) {
        OpenUserCatalog userCatalog = this.getUserCatalog(username);
        Model<?, ?, ?> model = userCatalog.getUntyped(modelName);
        if (model == null && failOnMissing) {
            throw new NoSuchElementException(StringSimilarity.prettySuggestions((String)OpenModelCatalog.formatWithLocale("Model with name `%s` does not exist.", modelName), (CharSequence)modelName, userCatalog.availableModelNames()));
        }
        return model;
    }

    @Contract(value="_, _, true -> !null")
    @Nullable
    private Model<?, ?, ?> drop(String username, String modelName, boolean failOnMissing) {
        return this.getUserCatalog(username).drop(modelName, failOnMissing);
    }

    private OpenUserCatalog getUserCatalog(String username) {
        return this.userCatalogs.getOrDefault(username, new OpenUserCatalog());
    }

    private static String formatWithLocale(String template, Object ... inputs) {
        return String.format(Locale.ENGLISH, template, inputs);
    }
}

