/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.model;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.core.StringSimilarity;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.core.model.UserCatalog;
import org.neo4j.gds.model.ModelConfig;

class OpenUserCatalog
implements UserCatalog {
    private static final long ALLOWED_MODELS_COUNT = 3L;
    private final Map<String, Model<?, ?, ?>> userModels = new ConcurrentHashMap();

    OpenUserCatalog() {
    }

    public <D, C extends ModelConfig, I extends ToMapConvertible> Model<D, C, I> get(String modelName, Class<D> dataClass, Class<C> configClass, Class<I> infoClass) {
        return this.get(this.getUntyped(modelName), dataClass, configClass, infoClass);
    }

    public Model<?, ?, ?> getUntyped(String modelName) {
        return this.userModels.get(modelName);
    }

    public void set(Model<?, ?, ?> model) {
        this.verifyModelCanBeStored(model.name(), model.algoType());
        this.userModels.put(model.name(), model);
    }

    public Collection<Model<?, ?, ?>> list() {
        return this.userModels.values();
    }

    public Model<?, ?, ?> list(String modelName) {
        return this.getUntyped(modelName);
    }

    public Stream<Model<?, ?, ?>> streamModels() {
        return this.userModels.values().stream();
    }

    public Set<String> availableModelNames() {
        return this.userModels.keySet();
    }

    public boolean exists(String modelName) {
        return this.userModels.containsKey(modelName);
    }

    public Optional<String> type(String modelName) {
        return Optional.ofNullable(this.userModels.get(modelName)).map(Model::algoType);
    }

    public Model<?, ?, ?> drop(String modelName, boolean failOnMissing) {
        Model<?, ?, ?> storedModel = this.userModels.remove(modelName);
        if (failOnMissing && storedModel == null) {
            throw new NoSuchElementException(StringSimilarity.prettySuggestions((String)OpenUserCatalog.formatWithLocale("Model with name `%s` does not exist.", modelName), (CharSequence)modelName, this.userModels.keySet()));
        }
        return storedModel;
    }

    public void removeAllLoadedModels() {
        this.userModels.clear();
    }

    public void verifyModelCanBeStored(String modelName, String modelType) {
        this.verifyModelNameIsUnique(modelName);
        this.verifyModelsLimit(modelType);
    }

    public long size() {
        return this.userModels.size();
    }

    private <D, C extends ModelConfig, I extends ToMapConvertible> Model<D, C, I> get(Model<?, ?, ?> model, Class<D> dataClass, Class<C> configClass, Class<I> infoClass) {
        if (model != null) {
            String modelName = model.name();
            if (!dataClass.isInstance(model.data())) {
                throw new IllegalArgumentException(OpenUserCatalog.formatWithLocale("The model `%s` has data with different types than expected. Expected data type: `%s`, invoked with model data type: `%s`.", modelName, model.data().getClass().getName(), dataClass.getName()));
            }
            if (!configClass.isInstance(model.trainConfig())) {
                throw new IllegalArgumentException(OpenUserCatalog.formatWithLocale("The model `%s` has a training config with different types than expected. Expected train config type: `%s`, invoked with model config type: `%s`.", modelName, model.trainConfig().getClass().getName(), configClass.getName()));
            }
            if (!infoClass.isInstance(model.customInfo())) {
                throw new IllegalArgumentException(OpenUserCatalog.formatWithLocale("The model `%s` has a customInfo with different types than expected. Expected customInfo type: `%s`, invoked with model info type: `%s`.", modelName, model.customInfo().getClass().getName(), infoClass.getName()));
            }
        }
        return model;
    }

    private void verifyModelNameIsUnique(String model) {
        if (this.exists(model)) {
            throw new IllegalArgumentException(OpenUserCatalog.formatWithLocale("Model with name `%s` already exists.", model));
        }
    }

    private void verifyModelsLimit(String modelType) {
        if (!this.canStoreModel(modelType)) {
            throw new IllegalStateException(OpenUserCatalog.formatWithLocale("Storing more than `%d` models in the catalog is not available in openGDS. Please consider licensing the Graph Data Science library. See documentation at https://neo4j.com/docs/graph-data-science/", 3L));
        }
    }

    private boolean canStoreModel(String modelType) {
        return this.modelsPerType(modelType) < 3L;
    }

    private long modelsPerType(String modelType) {
        return this.userModels.values().stream().filter(model -> model.algoType().equals(modelType)).count();
    }

    private static String formatWithLocale(String template, Object ... inputs) {
        return String.format(Locale.ENGLISH, template, inputs);
    }
}

