/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline;

import org.neo4j.gds.utils.StringFormatting;

public final class NonEmptySetValidation {
    public static final int MIN_SET_SIZE = 1;
    public static final int MIN_TRAIN_SET_SIZE = 2;
    public static final int MIN_TEST_COMPLEMENT_SET_SIZE = 3;

    private NonEmptySetValidation() {
    }

    public static void validateNodeSetSize(long numberNodesInSet, long minNumberNodes, String setName, String parameterName) {
        NonEmptySetValidation.validateElementSetIsNotEmpty(numberNodesInSet, minNumberNodes, setName, parameterName, "node(s)");
    }

    public static void validateRelSetSize(long numberNodesInSet, long minNumberNodes, String errorDesc, String parameterName) {
        NonEmptySetValidation.validateElementSetIsNotEmpty(numberNodesInSet, minNumberNodes, errorDesc, parameterName, "relationship(s)");
    }

    private static void validateElementSetIsNotEmpty(long elementsInSet, long expectedMinNumberOfElements, String errorDesc, String parameterName, String elementType) {
        if (elementsInSet < expectedMinNumberOfElements) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The specified %s for the current graph. The %s set would have %d %s but it must have at least %d.", (Object[])new Object[]{parameterName, errorDesc, elementsInSet, elementType, expectedMinNumberOfElements}));
        }
    }
}

