/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.ml.pipeline.ImmutablePipelineCatalogEntry;
import org.neo4j.gds.ml.pipeline.TrainingPipeline;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkPredictionTrainingPipeline;
import org.neo4j.gds.ml.pipeline.nodePipeline.classification.NodeClassificationTrainingPipeline;
import org.neo4j.gds.utils.StringFormatting;

public final class PipelineCatalog {
    private static final ConcurrentHashMap<String, PipelineUserCatalog> userCatalogs = new ConcurrentHashMap();
    private static final Map<Class<?>, String> classToType = Map.of(NodeClassificationTrainingPipeline.class, "Node classification training pipeline", LinkPredictionTrainingPipeline.class, "Link prediction training pipeline");

    private PipelineCatalog() {
    }

    public static void set(String user, String pipelineName, TrainingPipeline<?> pipeline) {
        userCatalogs.computeIfAbsent(user, ignore -> new PipelineUserCatalog()).set(pipelineName, pipeline);
    }

    public static boolean exists(String user, String pipelineName) {
        return userCatalogs.getOrDefault(user, PipelineUserCatalog.EMPTY).exists(pipelineName);
    }

    public static TrainingPipeline<?> get(String user, String pipelineName) {
        return userCatalogs.getOrDefault(user, PipelineUserCatalog.EMPTY).get(pipelineName).orElseThrow(() -> PipelineCatalog.createPipelineNotFoundException(user, pipelineName));
    }

    public static <PIPELINE extends TrainingPipeline<?>> PIPELINE getTyped(String user, String pipelineName, Class<PIPELINE> expectedClass) {
        TrainingPipeline<?> pipeline = PipelineCatalog.get(user, pipelineName);
        if (!expectedClass.isInstance(pipeline)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The pipeline `%s` is of type `%s`, but expected type `%s`.", (Object[])new Object[]{pipelineName, pipeline.type(), classToType.getOrDefault(expectedClass, expectedClass.getSimpleName())}));
        }
        return (PIPELINE)pipeline;
    }

    public static TrainingPipeline<?> drop(String user, String pipelineName) {
        return userCatalogs.getOrDefault(user, PipelineUserCatalog.EMPTY).drop(pipelineName).orElseThrow(() -> PipelineCatalog.createPipelineNotFoundException(user, pipelineName));
    }

    public static void removeAll() {
        userCatalogs.clear();
    }

    public static Stream<PipelineCatalogEntry> getAllPipelines(String user) {
        return userCatalogs.getOrDefault(user, PipelineUserCatalog.EMPTY).stream();
    }

    @NotNull
    private static NoSuchElementException createPipelineNotFoundException(String user, String pipelineName) {
        return new NoSuchElementException(StringFormatting.formatWithLocale((String)"Pipeline with name `%s` does not exist for user `%s`.", (Object[])new Object[]{pipelineName, user}));
    }

    static class PipelineUserCatalog {
        private final Map<String, TrainingPipeline<?>> pipelineByName = new ConcurrentHashMap();
        private static final PipelineUserCatalog EMPTY = new PipelineUserCatalog();

        PipelineUserCatalog() {
        }

        public void set(String pipelineName, TrainingPipeline<?> pipeline) {
            if (this.pipelineByName.containsKey(pipelineName)) {
                throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Pipeline named `%s` already exists.", (Object[])new Object[]{pipelineName}));
            }
            this.pipelineByName.put(pipelineName, pipeline);
        }

        public boolean exists(String pipelineName) {
            return this.pipelineByName.containsKey(pipelineName);
        }

        public Optional<TrainingPipeline<?>> get(String pipelineName) {
            return Optional.ofNullable(this.pipelineByName.get(pipelineName));
        }

        public Optional<TrainingPipeline<?>> drop(String pipelineName) {
            return Optional.ofNullable(this.pipelineByName.remove(pipelineName));
        }

        Stream<PipelineCatalogEntry> stream() {
            return this.pipelineByName.entrySet().stream().map(mapEntry -> ImmutablePipelineCatalogEntry.of((String)mapEntry.getKey(), (TrainingPipeline)mapEntry.getValue()));
        }
    }

    @ValueClass
    public static interface PipelineCatalogEntry {
        public String pipelineName();

        public TrainingPipeline<?> pipeline();
    }
}

