/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline;

import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphNameConfig;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.ml.pipeline.NodePropertyStepExecutor;
import org.neo4j.gds.ml.pipeline.Pipeline;
import org.neo4j.gds.ml.pipeline.PipelineGraphFilter;

public abstract class PredictPipelineExecutor<PIPELINE_CONFIG extends AlgoBaseConfig & GraphNameConfig, PIPELINE extends Pipeline<?>, RESULT>
extends Algorithm<RESULT> {
    protected final PIPELINE pipeline;
    protected final PIPELINE_CONFIG config;
    protected final ExecutionContext executionContext;
    protected final GraphStore graphStore;

    protected PredictPipelineExecutor(PIPELINE pipeline, PIPELINE_CONFIG config, ExecutionContext executionContext, GraphStore graphStore, ProgressTracker progressTracker) {
        super(progressTracker);
        this.pipeline = pipeline;
        this.config = config;
        this.executionContext = executionContext;
        this.graphStore = graphStore;
    }

    protected abstract RESULT execute();

    protected abstract PipelineGraphFilter nodePropertyStepFilter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RESULT compute() {
        this.progressTracker.beginSubTask();
        PipelineGraphFilter nodePropertyStepFilter = this.nodePropertyStepFilter();
        this.pipeline.validateBeforeExecution(this.graphStore, nodePropertyStepFilter.nodeLabels());
        NodePropertyStepExecutor<PIPELINE_CONFIG> nodePropertyStepExecutor = NodePropertyStepExecutor.of(this.executionContext, this.graphStore, this.config, nodePropertyStepFilter.nodeLabels(), nodePropertyStepFilter.relationshipTypes(), this.graphStore.relationshipTypes(), this.progressTracker);
        try {
            nodePropertyStepExecutor.executeNodePropertySteps(this.pipeline.nodePropertySteps());
            this.pipeline.validateFeatureProperties(this.graphStore, nodePropertyStepFilter.nodeLabels());
            RESULT result = this.execute();
            this.progressTracker.endSubTask();
            RESULT RESULT = result;
            return RESULT;
        }
        finally {
            nodePropertyStepExecutor.cleanupIntermediateProperties(this.pipeline.nodePropertySteps());
        }
    }

    public void release() {
    }
}

