/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.linkPipeline;

import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.utils.partition.DegreePartition;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureExtractor;

class BatchLinkFeatureExtractor
implements Runnable {
    final LinkFeatureExtractor extractor;
    final DegreePartition partition;
    final long relationshipOffset;
    final Graph graph;
    final HugeObjectArray<double[]> linkFeatures;
    final ProgressTracker progressTracker;

    BatchLinkFeatureExtractor(LinkFeatureExtractor extractor, DegreePartition partition, Graph graph, long relationshipOffset, HugeObjectArray<double[]> linkFeatures, ProgressTracker progressTracker) {
        this.extractor = extractor;
        this.partition = partition;
        this.relationshipOffset = relationshipOffset;
        this.graph = graph;
        this.linkFeatures = linkFeatures;
        this.progressTracker = progressTracker;
    }

    @Override
    public void run() {
        MutableLong currentRelationshipOffset = new MutableLong(this.relationshipOffset);
        this.partition.consume(nodeId -> this.graph.forEachRelationship(nodeId, (sourceNodeId, targetNodeId) -> {
            double[] features = this.extractor.extractFeatures(sourceNodeId, targetNodeId);
            this.linkFeatures.set(currentRelationshipOffset.getAndIncrement(), (Object)features);
            return true;
        }));
        this.progressTracker.logSteps(this.partition.totalDegree());
    }
}

