/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.linkPipeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.models.TrainerConfig;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkPredictionModelInfo;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkPredictionPredictPipeline;

@ParametersAreNonnullByDefault
@Generated(from="LinkPredictionModelInfo", generator="Immutables")
@Immutable
public final class ImmutableLinkPredictionModelInfo
implements LinkPredictionModelInfo {
    private final TrainerConfig bestParameters;
    private final Map<String, Object> metrics;
    private final LinkPredictionPredictPipeline pipeline;

    private ImmutableLinkPredictionModelInfo(TrainerConfig bestParameters, Map<String, ? extends Object> metrics, LinkPredictionPredictPipeline pipeline) {
        this.bestParameters = Objects.requireNonNull(bestParameters, "bestParameters");
        this.metrics = ImmutableLinkPredictionModelInfo.createUnmodifiableMap(true, false, metrics);
        this.pipeline = Objects.requireNonNull(pipeline, "pipeline");
    }

    private ImmutableLinkPredictionModelInfo(ImmutableLinkPredictionModelInfo original, TrainerConfig bestParameters, Map<String, Object> metrics, LinkPredictionPredictPipeline pipeline) {
        this.bestParameters = bestParameters;
        this.metrics = metrics;
        this.pipeline = pipeline;
    }

    @Override
    public TrainerConfig bestParameters() {
        return this.bestParameters;
    }

    @Override
    public Map<String, Object> metrics() {
        return this.metrics;
    }

    @Override
    public LinkPredictionPredictPipeline pipeline() {
        return this.pipeline;
    }

    public final ImmutableLinkPredictionModelInfo withBestParameters(TrainerConfig value) {
        if (this.bestParameters == value) {
            return this;
        }
        TrainerConfig newValue = Objects.requireNonNull(value, "bestParameters");
        return new ImmutableLinkPredictionModelInfo(this, newValue, this.metrics, this.pipeline);
    }

    public final ImmutableLinkPredictionModelInfo withMetrics(Map<String, ? extends Object> entries) {
        if (this.metrics == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableLinkPredictionModelInfo.createUnmodifiableMap(true, false, entries);
        return new ImmutableLinkPredictionModelInfo(this, this.bestParameters, newValue, this.pipeline);
    }

    public final ImmutableLinkPredictionModelInfo withPipeline(LinkPredictionPredictPipeline value) {
        if (this.pipeline == value) {
            return this;
        }
        LinkPredictionPredictPipeline newValue = Objects.requireNonNull(value, "pipeline");
        return new ImmutableLinkPredictionModelInfo(this, this.bestParameters, this.metrics, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLinkPredictionModelInfo && this.equalTo((ImmutableLinkPredictionModelInfo)another);
    }

    private boolean equalTo(ImmutableLinkPredictionModelInfo another) {
        return this.bestParameters.equals(another.bestParameters) && this.metrics.equals(another.metrics) && this.pipeline.equals(another.pipeline);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.bestParameters.hashCode();
        h += (h << 5) + this.metrics.hashCode();
        h += (h << 5) + this.pipeline.hashCode();
        return h;
    }

    public String toString() {
        return "LinkPredictionModelInfo{bestParameters=" + this.bestParameters + ", metrics=" + this.metrics + ", pipeline=" + this.pipeline + "}";
    }

    public static LinkPredictionModelInfo of(TrainerConfig bestParameters, Map<String, ? extends Object> metrics, LinkPredictionPredictPipeline pipeline) {
        return new ImmutableLinkPredictionModelInfo(bestParameters, metrics, pipeline);
    }

    public static LinkPredictionModelInfo copyOf(LinkPredictionModelInfo instance) {
        if (instance instanceof ImmutableLinkPredictionModelInfo) {
            return (ImmutableLinkPredictionModelInfo)instance;
        }
        return ImmutableLinkPredictionModelInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="LinkPredictionModelInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BEST_PARAMETERS = 1L;
        private static final long INIT_BIT_PIPELINE = 2L;
        private long initBits = 3L;
        @Nullable
        private TrainerConfig bestParameters;
        private Map<String, Object> metrics = null;
        @Nullable
        private LinkPredictionPredictPipeline pipeline;

        private Builder() {
        }

        public final Builder from(LinkPredictionModelInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.bestParameters(instance.bestParameters());
            this.putAllMetrics(instance.metrics());
            this.pipeline(instance.pipeline());
            return this;
        }

        public final Builder bestParameters(TrainerConfig bestParameters) {
            this.bestParameters = Objects.requireNonNull(bestParameters, "bestParameters");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder putMetric(String key, Object value) {
            if (this.metrics == null) {
                this.metrics = new LinkedHashMap<String, Object>();
            }
            this.metrics.put(Objects.requireNonNull(key, "metrics key"), Objects.requireNonNull(value, "metrics value"));
            return this;
        }

        public final Builder putMetric(Map.Entry<String, ? extends Object> entry) {
            if (this.metrics == null) {
                this.metrics = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.metrics.put(Objects.requireNonNull(k, "metrics key"), Objects.requireNonNull(v, "metrics value"));
            return this;
        }

        public final Builder metrics(Map<String, ? extends Object> entries) {
            this.metrics = new LinkedHashMap<String, Object>();
            return this.putAllMetrics(entries);
        }

        public final Builder putAllMetrics(Map<String, ? extends Object> entries) {
            if (this.metrics == null) {
                this.metrics = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.metrics.put(Objects.requireNonNull(k, "metrics key"), Objects.requireNonNull(v, "metrics value"));
            }
            return this;
        }

        public final Builder pipeline(LinkPredictionPredictPipeline pipeline) {
            this.pipeline = Objects.requireNonNull(pipeline, "pipeline");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.bestParameters = null;
            if (this.metrics != null) {
                this.metrics.clear();
            }
            this.pipeline = null;
            return this;
        }

        public LinkPredictionModelInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLinkPredictionModelInfo(null, this.bestParameters, this.metrics == null ? Collections.emptyMap() : ImmutableLinkPredictionModelInfo.createUnmodifiableMap(false, false, this.metrics), this.pipeline);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("bestParameters");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("pipeline");
            }
            return "Cannot build LinkPredictionModelInfo, some of required attributes are not set " + attributes;
        }
    }
}

