/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.linkPipeline;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureStep;
import org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions.CosineFeatureStep;
import org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions.HadamardFeatureStep;
import org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions.L2FeatureStep;
import org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions.LinkFeatureStepConfiguration;
import org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions.SameCategoryStep;
import org.neo4j.gds.utils.StringFormatting;

public enum LinkFeatureStepFactory {
    HADAMARD{

        @Override
        public LinkFeatureStep create(LinkFeatureStepConfiguration config) {
            return new HadamardFeatureStep(config.nodeProperties());
        }
    }
    ,
    COSINE{

        @Override
        protected LinkFeatureStep create(LinkFeatureStepConfiguration config) {
            return new CosineFeatureStep(config.nodeProperties());
        }
    }
    ,
    L2{

        @Override
        protected LinkFeatureStep create(LinkFeatureStepConfiguration config) {
            return new L2FeatureStep(config.nodeProperties());
        }
    }
    ,
    SAME_CATEGORY{

        @Override
        protected LinkFeatureStep create(LinkFeatureStepConfiguration config) {
            return new SameCategoryStep(config.nodeProperties());
        }
    };

    public static final List<String> VALUES;

    protected abstract LinkFeatureStep create(LinkFeatureStepConfiguration var1);

    private static LinkFeatureStepFactory parse(String input) {
        String inputString = StringFormatting.toUpperCaseWithLocale((String)input);
        if (VALUES.contains(inputString)) {
            return LinkFeatureStepFactory.valueOf(inputString);
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"LinkFeatureStep `%s` is not supported. Must be one of: %s.", (Object[])new Object[]{input, VALUES}));
    }

    public static LinkFeatureStep create(String taskName, LinkFeatureStepConfiguration config) {
        LinkFeatureStepFactory factory = LinkFeatureStepFactory.parse(taskName);
        return factory.create(config);
    }

    static {
        VALUES = Arrays.stream(LinkFeatureStepFactory.values()).map(Enum::name).collect(Collectors.toList());
    }
}

