/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions;

import java.util.List;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.ml.pipeline.FeatureStepUtil;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureAppender;
import org.neo4j.gds.utils.StringFormatting;

public abstract class AbstractLinkFeatureAppenderFactory {
    protected abstract LinkFeatureAppender doubleArrayAppender(NodePropertyValues var1, int var2);

    protected abstract LinkFeatureAppender floatArrayAppender(NodePropertyValues var1, int var2);

    protected abstract LinkFeatureAppender longArrayAppender(NodePropertyValues var1, int var2);

    protected abstract LinkFeatureAppender longAppender(NodePropertyValues var1, int var2);

    protected abstract LinkFeatureAppender doubleAppender(NodePropertyValues var1, int var2);

    private LinkFeatureAppender createAppender(Graph graph, String propertyName) {
        NodePropertyValues props = graph.nodeProperties(propertyName);
        ValueType propertyType = props.valueType();
        int dimension = FeatureStepUtil.propertyDimension(graph, propertyName);
        switch (propertyType) {
            case DOUBLE_ARRAY: {
                return this.doubleArrayAppender(props, dimension);
            }
            case FLOAT_ARRAY: {
                return this.floatArrayAppender(props, dimension);
            }
            case LONG_ARRAY: {
                return this.longArrayAppender(props, dimension);
            }
            case LONG: {
                return this.longAppender(props, dimension);
            }
            case DOUBLE: {
                return this.doubleAppender(props, dimension);
            }
        }
        throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Unsupported ValueType %s", (Object[])new Object[]{propertyType}));
    }

    LinkFeatureAppender[] createAppenders(Graph graph, List<String> propertyNames) {
        LinkFeatureAppender[] appenderPerProperty = new LinkFeatureAppender[propertyNames.size()];
        int nodePropertiesSize = propertyNames.size();
        for (int idx = 0; idx < nodePropertiesSize; ++idx) {
            appenderPerProperty[idx] = this.createAppender(graph, propertyNames.get(idx));
        }
        return appenderPerProperty;
    }
}

